/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.jira.infra;

import com.atlassian.httpclient.api.Request;
import com.atlassian.httpclient.api.factory.Scheme;
import com.atlassian.jira.rest.client.api.AuthenticationHandler;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.BasicIssue;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.input.IssueInput;
import com.atlassian.jira.rest.client.api.domain.input.IssueInputBuilder;
import com.atlassian.jira.rest.client.internal.async.AsynchronousJiraRestClient;
import com.atlassian.jira.rest.client.internal.async.DisposableHttpClient;
import com.chutneytesting.jira.domain.JiraServerConfiguration;
import com.chutneytesting.jira.domain.JiraXrayApi;
import com.chutneytesting.jira.domain.exception.NoJiraConfigurationException;
import com.chutneytesting.jira.infra.atlassian.httpclient.api.factory.HttpClientOptions;
import com.chutneytesting.jira.infra.atlassian.httpclient.api.factory.ProxyOptions;
import com.chutneytesting.jira.infra.atlassian.jira.rest.client.internal.async.AsynchronousHttpClientFactory;
import com.chutneytesting.jira.xrayapi.JiraIssueType;
import com.chutneytesting.jira.xrayapi.Xray;
import com.chutneytesting.jira.xrayapi.XrayTestExecTest;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class HttpJiraXrayImpl
implements JiraXrayApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpJiraXrayImpl.class);
    private static final int MS_TIMEOUT = 10000;
    private final JiraServerConfiguration jiraServerConfiguration;

    public HttpJiraXrayImpl(JiraServerConfiguration jiraServerConfiguration) {
        this.jiraServerConfiguration = jiraServerConfiguration;
        if (!jiraServerConfiguration.isValid()) {
            throw new NoJiraConfigurationException();
        }
    }

    @Override
    public void updateRequest(Xray xray) {
        String updateUri = this.jiraServerConfiguration.url() + "/rest/raven/1.0/import/execution";
        RestTemplate restTemplate = this.buildRestTemplate();
        try {
            ResponseEntity response = restTemplate.postForEntity(updateUri, (Object)xray, String.class, new Object[0]);
            if (response.getStatusCode().equals(HttpStatus.OK)) {
                LOGGER.debug(response.toString());
                LOGGER.info("Xray successfully updated for " + xray.getTestExecutionKey());
            } else {
                LOGGER.error(response.toString());
            }
        }
        catch (RestClientException e) {
            throw new RuntimeException("Unable to update test execution [" + xray.getTestExecutionKey() + "] : ", e);
        }
    }

    @Override
    public List<XrayTestExecTest> getTestExecutionScenarios(String xrayId) {
        List<XrayTestExecTest> tests = new ArrayList<XrayTestExecTest>();
        String uriTemplate = this.jiraServerConfiguration.url() + "/rest/raven/1.0/api/%s/%s/test";
        String uri = String.format(uriTemplate, this.isTestPlan(xrayId) ? "testplan" : "testexec", xrayId);
        RestTemplate restTemplate = this.buildRestTemplate();
        try {
            ResponseEntity response = restTemplate.getForEntity(uri, XrayTestExecTest[].class, new Object[0]);
            if (response.getStatusCode().equals(HttpStatus.OK) && response.getBody() != null) {
                tests = Arrays.stream((XrayTestExecTest[])response.getBody()).toList();
            } else {
                LOGGER.error(response.toString());
            }
        }
        catch (RestClientException e) {
            throw new RuntimeException("Unable to get xray test execution[" + xrayId + "] scenarios : ", e);
        }
        return tests;
    }

    @Override
    public void updateStatusByTestRunId(String testRuntId, String executionStatus) {
        String uriTemplate = this.jiraServerConfiguration.url() + "/rest/raven/1.0/api/testrun/%s/status?status=%s";
        String uri = String.format(uriTemplate, testRuntId, executionStatus);
        RestTemplate restTemplate = this.buildRestTemplate();
        try {
            restTemplate.put(uri, null, new Object[0]);
        }
        catch (RestClientException e) {
            throw new RuntimeException("Unable to update xray testRuntId[" + testRuntId + "] with status[" + executionStatus + "] : ", e);
        }
    }

    @Override
    public void associateTestExecutionFromTestPlan(String testPlanId, String testExecutionId) {
        String uriTemplate = this.jiraServerConfiguration.url() + "/rest/raven/1.0/api/testplan/%s/testexecution";
        String uri = String.format(uriTemplate, testPlanId);
        RestTemplate restTemplate = this.buildRestTemplate();
        try {
            ResponseEntity response = restTemplate.postForEntity(uri, Map.of("add", List.of(testExecutionId)), String.class, new Object[0]);
            if (!response.getStatusCode().equals(HttpStatus.OK)) {
                LOGGER.error(response.toString());
                throw new RuntimeException("Unable to associate test execution [" + testExecutionId + "] from test plan [" + testPlanId + "]");
            }
            LOGGER.debug(response.toString());
            LOGGER.info("Xray successfully associate test execution [" + testExecutionId + "] from test plan [" + testPlanId + "]");
        }
        catch (RestClientException e) {
            throw new RuntimeException("Unable to associate test execution [" + testExecutionId + "] from test plan [" + testPlanId + "] : ", e);
        }
    }

    @Override
    public String createTestExecution(String testPlanId) {
        String string;
        block8: {
            Issue parentIssue = this.getIssue(testPlanId);
            IssueInputBuilder issueInputBuilder = new IssueInputBuilder();
            IssueInput issueInput = issueInputBuilder.setProjectKey(parentIssue.getProject().getKey()).setIssueTypeId(this.getIssueTypeByName("Test Execution").getId()).setSummary(parentIssue.getSummary()).build();
            JiraRestClient jiraRestClient = this.getJiraRestClient();
            try {
                BasicIssue issue = (BasicIssue)jiraRestClient.getIssueClient().createIssue(issueInput).claim();
                this.associateTestExecutionFromTestPlan(testPlanId, issue.getKey());
                string = issue.getKey();
                if (jiraRestClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jiraRestClient != null) {
                        try {
                            jiraRestClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to create test execution issue from test plan [" + testPlanId + "] : ", e);
                }
            }
            jiraRestClient.close();
        }
        return string;
    }

    @Override
    public boolean isTestPlan(String issueId) {
        return this.getIssue(issueId).getIssueType().getId().equals(this.getIssueTypeByName("Test Plan").getId());
    }

    private Issue getIssue(String issueKey) {
        Issue issue;
        block8: {
            JiraRestClient jiraRestClient = this.getJiraRestClient();
            try {
                issue = (Issue)jiraRestClient.getIssueClient().getIssue(issueKey).claim();
                if (jiraRestClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jiraRestClient != null) {
                        try {
                            jiraRestClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to get issue [" + issueKey + "] : ", e);
                }
            }
            jiraRestClient.close();
        }
        return issue;
    }

    private JiraIssueType getIssueTypeByName(String issueTypeName) {
        String uri = this.jiraServerConfiguration.url() + "/rest/api/latest/issuetype";
        Optional<Object> issueTypeOptional = Optional.empty();
        RestTemplate restTemplate = this.buildRestTemplate();
        try {
            ResponseEntity response = restTemplate.getForEntity(uri, JiraIssueType[].class, new Object[0]);
            if (response.getStatusCode().equals(HttpStatus.OK) && response.getBody() != null) {
                issueTypeOptional = Arrays.stream((JiraIssueType[])response.getBody()).filter(issueType -> issueType.getName().equals(issueTypeName)).findFirst();
            } else {
                LOGGER.error(response.toString());
            }
        }
        catch (RestClientException e) {
            throw new RuntimeException("Unable to get issues type list : ", e);
        }
        return (JiraIssueType)issueTypeOptional.orElseThrow(() -> new RuntimeException("Unable to get issue type [" + issueTypeName + "]"));
    }

    private RestTemplate buildRestTemplate() {
        try {
            HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory(this.buildHttpClient());
            requestFactory.setConnectTimeout(10000);
            return new RestTemplate((ClientHttpRequestFactory)requestFactory);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot build rest template.", e);
        }
    }

    private HttpClient buildHttpClient() throws URISyntaxException {
        HttpHost httpHost = HttpHost.create((URI)new URI(this.jiraServerConfiguration.url()));
        HttpHost proxyHttpHost = null;
        if (!this.jiraServerConfiguration.urlProxy().isBlank()) {
            proxyHttpHost = HttpHost.create((URI)new URI(this.jiraServerConfiguration.urlProxy()));
        }
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager(this.buildConnectionManager()).setDefaultCredentialsProvider((CredentialsProvider)this.getBasicCredentialsProvider(httpHost, proxyHttpHost));
        ArrayList<BasicHeader> defaultHeaders = new ArrayList<BasicHeader>();
        String authorization = HttpJiraXrayImpl.basicAuthHeaderEncodedValue(this.jiraServerConfiguration.username(), this.jiraServerConfiguration.password());
        defaultHeaders.add(new BasicHeader("Authorization", (Object)authorization));
        if (this.jiraServerConfiguration.hasProxy()) {
            httpClientBuilder.setProxy(proxyHttpHost);
            if (this.jiraServerConfiguration.hasProxyWithAuth()) {
                String proxyAuthorization = HttpJiraXrayImpl.basicAuthHeaderEncodedValue(this.jiraServerConfiguration.userProxy(), this.jiraServerConfiguration.passwordProxy());
                defaultHeaders.add(new BasicHeader("Proxy-Authorization", (Object)proxyAuthorization));
            }
        }
        httpClientBuilder.setDefaultHeaders(defaultHeaders);
        return httpClientBuilder.build();
    }

    private HttpClientConnectionManager buildConnectionManager() {
        SSLContext sslContext = this.buildSslContext();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        return PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(10000, TimeUnit.MILLISECONDS).build()).build();
    }

    private SSLContext buildSslContext() {
        try {
            SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
            sslContextBuilder.loadTrustMaterial(null, (chain, authType) -> true);
            return sslContextBuilder.build();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static String basicAuthHeaderEncodedValue(String user, String password) {
        return "Basic " + Base64.getEncoder().encodeToString((user + ":" + password).getBytes());
    }

    private BasicCredentialsProvider getBasicCredentialsProvider(HttpHost httpHost, HttpHost proxyHttpHost) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(httpHost), (Credentials)new UsernamePasswordCredentials(this.jiraServerConfiguration.username(), this.jiraServerConfiguration.password().toCharArray()));
        if (this.jiraServerConfiguration.hasProxyWithAuth()) {
            credentialsProvider.setCredentials(new AuthScope(proxyHttpHost), (Credentials)new UsernamePasswordCredentials(this.jiraServerConfiguration.userProxy(), this.jiraServerConfiguration.passwordProxy().toCharArray()));
        }
        return credentialsProvider;
    }

    private JiraRestClient getJiraRestClient() throws URISyntaxException {
        URI serverUri = URI.create(this.jiraServerConfiguration.url());
        return new AsynchronousJiraRestClient(serverUri, this.buildJiraHttpClient(serverUri, new BasicHttpAuthenticationHandler(this.jiraServerConfiguration.username(), this.jiraServerConfiguration.password(), this.jiraServerConfiguration.userProxy(), this.jiraServerConfiguration.passwordProxy())));
    }

    private DisposableHttpClient buildJiraHttpClient(URI serverUri, AuthenticationHandler authenticationHandler) throws URISyntaxException {
        HttpClientOptions options = new HttpClientOptions();
        options.setTrustSelfSignedCertificates(true);
        if (this.jiraServerConfiguration.hasProxy()) {
            HttpHost proxyHttpHost = HttpHost.create((URI)new URI(this.jiraServerConfiguration.urlProxy()));
            options.setProxyOptions(ProxyOptions.ProxyOptionsBuilder.create().withProxy(Scheme.valueOf((String)serverUri.getScheme().toUpperCase()), proxyHttpHost).build());
        }
        return AsynchronousHttpClientFactory.createClient(serverUri, authenticationHandler, options);
    }

    private record BasicHttpAuthenticationHandler(String username, String password, String proxyUsername, String proxyPassword) implements AuthenticationHandler
    {
        public void configure(Request.Builder builder) {
            builder.setHeader("Authorization", HttpJiraXrayImpl.basicAuthHeaderEncodedValue(this.username, this.password));
            if (this.proxyUsername != null && !this.proxyUsername.isBlank()) {
                builder.setHeader("Proxy-Authorization", HttpJiraXrayImpl.basicAuthHeaderEncodedValue(this.proxyUsername, this.proxyPassword));
            }
        }
    }
}

