/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.server.core.domain.scenario;

import com.chutneytesting.server.core.domain.scenario.TestCaseMetadata;
import com.chutneytesting.server.core.domain.security.User;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public final class TestCaseMetadataImpl
implements TestCaseMetadata {
    public final String id;
    public final String title;
    public final String description;
    public final List<String> tags;
    public final Instant creationDate;
    public final String defaultDataset;
    public final Instant updateDate;
    public final String author;
    public final Integer version;

    private TestCaseMetadataImpl(String id, String title, String description, List<String> tags, Instant creationDate, String defaultDataset, Instant updateDate, String author, Integer version) {
        this.id = id;
        this.title = title;
        this.description = description;
        this.tags = tags;
        this.creationDate = creationDate;
        this.defaultDataset = defaultDataset;
        this.updateDate = updateDate;
        this.author = author;
        this.version = version;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String defaultDataset() {
        return this.defaultDataset;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public Instant creationDate() {
        return this.creationDate;
    }

    @Override
    public List<String> tags() {
        return this.tags;
    }

    @Override
    public String author() {
        return this.author;
    }

    @Override
    public Instant updateDate() {
        return this.updateDate;
    }

    @Override
    public Integer version() {
        return this.version;
    }

    public String toString() {
        return "TestCaseMetadata{id=" + this.id + ", title='" + this.title + "', description='" + this.description + "', tags=" + this.tags + ", creationDate=" + this.creationDate + ", author=" + this.author + ", updateDate=" + this.updateDate + ", version=" + this.version + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestCaseMetadataImpl that = (TestCaseMetadataImpl)o;
        return this.id.equals(that.id) && this.title.equals(that.title) && this.description.equals(that.description) && this.tags.equals(that.tags) && this.creationDate.equals(that.creationDate) && this.author.equals(that.author) && this.updateDate.equals(that.updateDate) && this.version.equals(that.version);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.title, this.description, this.tags, this.creationDate, this.author, this.updateDate, this.version);
    }

    public static TestCaseMetadataBuilder builder() {
        return new TestCaseMetadataBuilder();
    }

    public static class TestCaseMetadataBuilder {
        private String id;
        private String title;
        private String description;
        private List<String> tags;
        private Instant creationDate;
        private String defaultDataset;
        private Instant updateDate;
        private String author;
        private Integer version;

        private TestCaseMetadataBuilder() {
        }

        public TestCaseMetadataImpl build() {
            Instant creationDate = Optional.ofNullable(this.creationDate).orElse(Instant.now());
            return new TestCaseMetadataImpl(Optional.ofNullable(this.id).orElse("-42"), Optional.ofNullable(this.title).orElse(""), Optional.ofNullable(this.description).orElse(""), Optional.ofNullable(this.tags).stream().flatMap(Collection::stream).filter(StringUtils::isNotBlank).map(String::toUpperCase).map(String::trim).collect(Collectors.toList()), creationDate, Optional.ofNullable(this.defaultDataset).orElse(""), Optional.ofNullable(this.updateDate).orElse(creationDate), Optional.ofNullable(this.author).orElseGet(() -> User.ANONYMOUS.id), Optional.ofNullable(this.version).orElse(1));
        }

        public TestCaseMetadataBuilder withId(String id) {
            this.id = id;
            return this;
        }

        public TestCaseMetadataBuilder withDefaultDataset(String defaultDataset) {
            this.defaultDataset = defaultDataset;
            return this;
        }

        public TestCaseMetadataBuilder withTitle(String title) {
            this.title = title;
            return this;
        }

        public TestCaseMetadataBuilder withDescription(String description) {
            this.description = description;
            return this;
        }

        public TestCaseMetadataBuilder withTags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public TestCaseMetadataBuilder withCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public TestCaseMetadataBuilder withUpdateDate(Instant updateDate) {
            this.updateDate = updateDate;
            return this;
        }

        public TestCaseMetadataBuilder withAuthor(String author) {
            this.author = author;
            return this;
        }

        public TestCaseMetadataBuilder withVersion(Integer version) {
            this.version = version;
            return this;
        }

        public static TestCaseMetadataBuilder from(TestCaseMetadata testCaseMetadata) {
            return new TestCaseMetadataBuilder().withId(testCaseMetadata.id()).withTitle(testCaseMetadata.title()).withDescription(testCaseMetadata.description()).withCreationDate(testCaseMetadata.creationDate()).withTags(testCaseMetadata.tags()).withDefaultDataset(testCaseMetadata.defaultDataset()).withUpdateDate(testCaseMetadata.updateDate()).withAuthor(testCaseMetadata.author()).withVersion(testCaseMetadata.version());
        }
    }
}

