/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.grpc;

import com.clickhouse.client.AbstractClient;
import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseCredentials;
import com.clickhouse.client.ClickHouseException;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.grpc.ClickHouseGrpcChannelFactory;
import com.clickhouse.client.grpc.ClickHouseGrpcResponse;
import com.clickhouse.client.grpc.ClickHouseStreamObserver;
import com.clickhouse.client.grpc.config.ClickHouseGrpcOption;
import com.clickhouse.client.grpc.impl.ClickHouseGrpc;
import com.clickhouse.client.grpc.impl.ExternalTable;
import com.clickhouse.client.grpc.impl.NameAndType;
import com.clickhouse.client.grpc.impl.QueryInfo;
import com.clickhouse.client.grpc.impl.Result;
import com.clickhouse.config.ClickHouseOption;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseCompression;
import com.clickhouse.data.ClickHouseDataStreamFactory;
import com.clickhouse.data.ClickHouseDeferredValue;
import com.clickhouse.data.ClickHouseExternalTable;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseOutputStream;
import com.clickhouse.data.ClickHousePipedOutputStream;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.logging.Logger;
import com.clickhouse.logging.LoggerFactory;
import com.google.protobuf.ByteString;
import io.grpc.Channel;
import io.grpc.Context;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorInputStream;
import org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorOutputStream;

public class ClickHouseGrpcClient
extends AbstractClient<ManagedChannel> {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseGrpcClient.class);
    static final List<ClickHouseProtocol> SUPPORTED = Collections.singletonList(ClickHouseProtocol.GRPC);

    static ClickHouseInputStream getInput(ClickHouseConfig config, InputStream input, Runnable postCloseAction) {
        ClickHouseInputStream in;
        switch (config.getResponseCompressAlgorithm()) {
            case LZ4: {
                in = ClickHouseInputStream.of((ClickHouseDeferredValue)ClickHouseDeferredValue.of(() -> {
                    try {
                        return new FramedLZ4CompressorInputStream(input);
                    }
                    catch (IOException e) {
                        return input;
                    }
                }), (int)config.getReadBufferSize(), (Runnable)postCloseAction);
                break;
            }
            default: {
                in = ClickHouseInputStream.wrap(null, (InputStream)input, (int)config.getReadBufferSize(), (ClickHouseCompression)config.getResponseCompressAlgorithm(), (int)config.getResponseCompressLevel(), (Runnable)postCloseAction);
            }
        }
        return in;
    }

    static ClickHouseOutputStream getOutput(ClickHouseConfig config, OutputStream output, Runnable postCloseAction) {
        ClickHouseOutputStream out;
        switch (config.getRequestCompressAlgorithm()) {
            case LZ4: {
                out = ClickHouseOutputStream.of((ClickHouseDeferredValue)ClickHouseDeferredValue.of(() -> {
                    try {
                        return new FramedLZ4CompressorOutputStream(output);
                    }
                    catch (IOException e) {
                        return output;
                    }
                }), (int)config.getWriteBufferSize(), (Runnable)postCloseAction);
                break;
            }
            default: {
                out = ClickHouseOutputStream.of((OutputStream)output, (int)config.getWriteBufferSize(), (ClickHouseCompression)config.getRequestCompressAlgorithm(), (int)config.getRequestCompressLevel(), (Runnable)postCloseAction);
            }
        }
        return out;
    }

    protected static ClickHouseInputStream getCompressedInputStream(ClickHouseConfig config, ClickHouseInputStream input) {
        if (!config.isRequestCompressed() || input.getUnderlyingStream().hasInput()) {
            return input;
        }
        int bufferSize = config.getWriteBufferSize();
        ClickHousePipedOutputStream stream = ClickHouseDataStreamFactory.getInstance().createPipedOutputStream(bufferSize, 0, config.getSocketTimeout(), null);
        ClickHouseInputStream compressedInput = stream.getInputStream();
        ClickHouseClient.submit(() -> {
            try (ClickHouseInputStream in = input;
                 ClickHouseOutputStream out = ClickHouseGrpcClient.getOutput(config, (OutputStream)stream, null);){
                in.pipe(out);
            }
            catch (Exception e) {
                log.warn((Object)"Failed to pipe data", (Throwable)e);
            }
        });
        return compressedInput;
    }

    protected static QueryInfo getChunkedInputData(ClickHouseNode server, ClickHouseInputStream input, byte[] bytes) {
        QueryInfo.Builder builder = QueryInfo.newBuilder();
        try {
            int read = input.read(bytes);
            ByteString bs = read > 0 ? ByteString.copyFrom((byte[])bytes, (int)0, (int)read) : ByteString.empty();
            builder.setInputData(bs);
            builder.setNextQueryInfo(read == bytes.length && input.available() > 0);
        }
        catch (IOException e) {
            throw new CompletionException((Throwable)ClickHouseException.of((Throwable)e, (ClickHouseNode)server));
        }
        return builder.build();
    }

    protected static QueryInfo convert(ClickHouseRequest<?> request, boolean streaming) {
        String sql;
        List list;
        int size;
        ClickHouseConfig config = request.getConfig();
        ClickHouseNode server = request.getServer();
        ClickHouseCredentials credentials = server.getCredentials(config);
        Optional input = request.getInputStream();
        QueryInfo.Builder builder = QueryInfo.newBuilder();
        String database = server.getDatabase(config);
        if (!ClickHouseChecker.isNullOrEmpty((CharSequence)database)) {
            builder.setDatabase(server.getDatabase(config));
        }
        builder.setUserName(credentials.getUserName()).setPassword(credentials.getPassword()).setOutputFormat(request.getFormat().name());
        Optional optionalValue = request.getSessionId();
        if (optionalValue.isPresent()) {
            builder.setSessionId((String)optionalValue.get());
        }
        if (config.isSessionCheck()) {
            builder.setSessionCheck(true);
        }
        if (config.getSessionTimeout() > 0) {
            builder.setSessionTimeout(config.getSessionTimeout());
        }
        if ((optionalValue = request.getQueryId()).isPresent()) {
            builder.setQueryId((String)optionalValue.get());
        }
        ClickHouseCompression outputCompression = config.getResponseCompressAlgorithm();
        builder.setOutputCompressionType(outputCompression.encoding());
        if (outputCompression != ClickHouseCompression.NONE && config.hasOption((ClickHouseOption)ClickHouseClientOption.COMPRESS_LEVEL)) {
            builder.setOutputCompressionLevel(config.getResponseCompressLevel());
        }
        for (Map.Entry entry : request.getSettings().entrySet()) {
            builder.putSettings((String)entry.getKey(), String.valueOf(entry.getValue()));
        }
        List externalTables = request.getExternalTables();
        if (!externalTables.isEmpty()) {
            for (ClickHouseExternalTable external : externalTables) {
                ExternalTable.Builder b = ExternalTable.newBuilder().setName(external.getName());
                for (ClickHouseColumn c : ClickHouseColumn.parse((String)external.getStructure())) {
                    b.addColumns(NameAndType.newBuilder().setName(c.getColumnName()).setType(c.getOriginalTypeName()).build());
                }
                if (external.getFormat() != null) {
                    b.setFormat(external.getFormat().name());
                }
                try {
                    builder.addExternalTables(b.setData(ByteString.readFrom((InputStream)external.getContent())).build());
                }
                catch (IOException e) {
                    throw new CompletionException((Throwable)ClickHouseException.of((Throwable)e, (ClickHouseNode)server));
                }
            }
        }
        if ((size = (list = request.getStatements(false)).size()) == 0) {
            throw new IllegalArgumentException("At least one SQL statement is required for execution");
        }
        if (size == 1) {
            sql = (String)list.get(0);
        } else {
            if (!builder.getSessionCheck()) {
                builder.setSessionCheck(true);
            }
            if (ClickHouseChecker.isNullOrEmpty((CharSequence)builder.getSessionId())) {
                builder.setSessionId(request.getManager().createSessionId());
            }
            StringBuilder sb = new StringBuilder();
            for (String s : list) {
                sb.append(s).append(';').append('\n');
            }
            sql = sb.toString();
        }
        if (input.isPresent()) {
            if (config.isRequestCompressed()) {
                builder.setInputCompressionType(config.getRequestCompressAlgorithm().encoding());
            }
            if (streaming) {
                builder.setNextQueryInfo(true);
            } else {
                try {
                    builder.setInputData(ByteString.readFrom((InputStream)ClickHouseGrpcClient.getCompressedInputStream(config, (ClickHouseInputStream)input.get())));
                }
                catch (IOException e) {
                    throw new CompletionException((Throwable)ClickHouseException.of((Throwable)e, (ClickHouseNode)server));
                }
            }
        }
        log.debug((Object)"Query(stream=%s): %s", new Object[]{streaming, sql});
        return builder.setQuery(sql).build();
    }

    protected boolean checkHealth(ClickHouseNode server, int timeout) {
        return true;
    }

    protected void closeConnection(ManagedChannel connection, boolean force) {
        if (!force) {
            connection.shutdown();
        } else {
            connection.shutdownNow();
        }
    }

    protected Collection<ClickHouseProtocol> getSupportedProtocols() {
        return SUPPORTED;
    }

    protected ManagedChannel newConnection(ManagedChannel connection, ClickHouseNode server, ClickHouseRequest<?> request) {
        if (connection != null) {
            this.closeConnection(connection, false);
        }
        return ClickHouseGrpcChannelFactory.getFactory(request.getConfig(), server).create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fill(ClickHouseRequest<?> request, StreamObserver<QueryInfo> observer) {
        block12: {
            try {
                QueryInfo queryInfo = ClickHouseGrpcClient.convert(request, true);
                boolean hasNext = queryInfo.getNextQueryInfo();
                observer.onNext((Object)queryInfo);
                if (!hasNext) break block12;
                ClickHouseNode server = request.getServer();
                ClickHouseConfig config = request.getConfig();
                try (ClickHouseInputStream input = ClickHouseGrpcClient.getCompressedInputStream(config, (ClickHouseInputStream)request.getInputStream().get());){
                    byte[] bytes = new byte[config.getRequestChunkSize()];
                    while (hasNext) {
                        queryInfo = ClickHouseGrpcClient.getChunkedInputData(server, input, bytes);
                        hasNext = queryInfo.getNextQueryInfo();
                        observer.onNext((Object)queryInfo);
                    }
                }
                catch (IOException e) {
                    throw new CompletionException((Throwable)ClickHouseException.of((Throwable)e, (ClickHouseNode)server));
                }
            }
            finally {
                observer.onCompleted();
            }
        }
    }

    protected Object[] getAsyncExecArguments(ClickHouseRequest<?> sealedRequest) {
        ClickHouseGrpc.ClickHouseStub stub = ClickHouseGrpc.newStub((Channel)this.getConnection(sealedRequest));
        ClickHouseStreamObserver responseObserver = new ClickHouseStreamObserver(sealedRequest.getConfig(), sealedRequest.getServer(), sealedRequest.getOutputStream().orElse(null));
        StreamObserver<QueryInfo> requestObserver = stub.executeQueryWithStreamIO(responseObserver);
        if (sealedRequest.hasInputStream()) {
            this.getExecutor().execute(() -> this.fill(sealedRequest, requestObserver));
        } else {
            this.fill(sealedRequest, requestObserver);
        }
        return new Object[]{requestObserver, responseObserver};
    }

    protected ClickHouseResponse sendAsync(ClickHouseRequest<?> sealedRequest, Object ... args) throws ClickHouseException, IOException {
        StreamObserver requestObserver = (StreamObserver)args[0];
        ClickHouseStreamObserver responseObserver = (ClickHouseStreamObserver)args[1];
        ClickHouseConfig config = sealedRequest.getConfig();
        int timeout = config.getConnectionTimeout() / 1000 + Math.max(config.getSocketTimeout() / 1000, config.getMaxExecutionTime());
        try {
            if (!responseObserver.await(timeout, TimeUnit.SECONDS)) {
                if (!Context.current().withCancellation().cancel((Throwable)new StatusException(Status.CANCELLED))) {
                    requestObserver.onError((Throwable)new StatusException(Status.CANCELLED));
                }
                throw new SocketTimeoutException(ClickHouseUtils.format((String)"Timed out after waiting for %d %s", (Object[])new Object[]{timeout, TimeUnit.SECONDS}));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw ClickHouseException.of((Throwable)e, (ClickHouseNode)sealedRequest.getServer());
        }
        ClickHouseGrpcResponse response = new ClickHouseGrpcResponse(sealedRequest.getConfig(), (Map<String, Serializable>)sealedRequest.getSettings(), responseObserver);
        IOException cause = responseObserver.getError();
        if (cause != null) {
            throw ClickHouseException.of((Throwable)cause, (ClickHouseNode)sealedRequest.getServer());
        }
        return response;
    }

    protected ClickHouseResponse send(ClickHouseRequest<?> sealedRequest) throws ClickHouseException, IOException {
        ManagedChannel channel = (ManagedChannel)this.getConnection(sealedRequest);
        ClickHouseGrpc.ClickHouseBlockingStub stub = ClickHouseGrpc.newBlockingStub((Channel)channel);
        Result result = stub.executeQuery(ClickHouseGrpcClient.convert(sealedRequest, false));
        ClickHouseGrpcResponse response = new ClickHouseGrpcResponse(sealedRequest.getConfig(), (Map<String, Serializable>)sealedRequest.getSettings(), result);
        if (result.hasException()) {
            throw new ClickHouseException(result.getException().getCode(), result.getException().getDisplayText(), sealedRequest.getServer());
        }
        return response;
    }

    public boolean accept(ClickHouseProtocol protocol) {
        return ClickHouseProtocol.GRPC == protocol || super.accept(protocol);
    }

    public Class<? extends ClickHouseOption> getOptionClass() {
        return ClickHouseGrpcOption.class;
    }
}

