/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.groovy.cps.impl;

import com.cloudbees.groovy.cps.Continuation;
import com.cloudbees.groovy.cps.Env;
import com.cloudbees.groovy.cps.impl.CallEnv;
import com.cloudbees.groovy.cps.impl.CpsClosure;
import com.cloudbees.groovy.cps.impl.SourceLocation;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class ClosureCallEnv
extends CallEnv {
    Map<String, Object> locals;
    final CpsClosure closure;
    final Env captured;
    private static final long serialVersionUID = 1L;

    public ClosureCallEnv(Env caller, Continuation returnAddress, SourceLocation loc, Env captured, CpsClosure closure) {
        this(caller, returnAddress, loc, captured, closure, 0);
    }

    public ClosureCallEnv(Env caller, Continuation returnAddress, SourceLocation loc, Env captured, CpsClosure closure, int localsSize) {
        super(caller, returnAddress, loc, localsSize);
        this.closure = closure;
        this.captured = captured;
        this.locals = localsSize <= 0 ? Collections.EMPTY_MAP : Maps.newHashMapWithExpectedSize((int)localsSize);
    }

    @Override
    public void declareVariable(Class type, String name) {
        if (this.locals == Collections.EMPTY_MAP) {
            this.locals = new HashMap<String, Object>(2);
        }
        this.locals.put(name, null);
        this.getTypesForMutation().put(name, type);
    }

    @Override
    public Object getLocalVariable(String name) {
        if (this.locals.containsKey(name)) {
            return this.locals.get(name);
        }
        return this.captured.getLocalVariable(name);
    }

    @Override
    public void setLocalVariable(String name, Object value) {
        if (this.locals.containsKey(name)) {
            this.locals.put(name, value);
        } else {
            this.captured.setLocalVariable(name, value);
        }
    }

    @Override
    public Class getLocalVariableType(String name) {
        return this.locals.containsKey(name) ? this.getTypes().get(name) : this.captured.getLocalVariableType(name);
    }

    @Override
    public Object closureOwner() {
        return this.closure;
    }
}

