/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Browser {
    public final String name;
    public final boolean headless;

    public Browser(String name, boolean headless) {
        this.name = name;
        this.headless = headless;
    }

    @CheckReturnValue
    public boolean isHeadless() {
        return this.headless;
    }

    @CheckReturnValue
    public boolean isChrome() {
        return "chrome".equalsIgnoreCase(this.name);
    }

    @CheckReturnValue
    public boolean isFirefox() {
        return "firefox".equalsIgnoreCase(this.name);
    }

    @CheckReturnValue
    public boolean isIE() {
        return "internet explorer".equalsIgnoreCase(this.name) || "ie".equalsIgnoreCase(this.name);
    }

    @CheckReturnValue
    public boolean isEdge() {
        return "edge".equalsIgnoreCase(this.name);
    }

    @CheckReturnValue
    public boolean isOpera() {
        return "opera".equalsIgnoreCase(this.name);
    }

    @CheckReturnValue
    public boolean isSafari() {
        return "safari".equalsIgnoreCase(this.name);
    }

    @CheckReturnValue
    public boolean supportsInsecureCerts() {
        return !this.isIE() && !this.isEdge() && !this.isSafari();
    }
}

