/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import javax.annotation.Nullable;

public class CheckResult
implements Serializable {
    private static final DateTimeFormatter timeFormat = DateTimeFormatter.ofPattern("HH:mm:ss:SSS");
    public final Verdict verdict;
    public final Object actualValue;
    public final LocalDateTime timestamp;

    public CheckResult(Verdict verdict, @Nullable Object actualValue, LocalDateTime timestamp) {
        this.verdict = verdict;
        this.actualValue = actualValue;
        this.timestamp = timestamp;
    }

    public CheckResult(Verdict verdict, @Nullable Object actualValue) {
        this(verdict, actualValue, LocalDateTime.now());
    }

    public CheckResult(boolean checkSucceeded, @Nullable Object actualValue) {
        this(checkSucceeded ? Verdict.ACCEPT : Verdict.REJECT, actualValue);
    }

    public String toString() {
        return String.format("%s @ %s%n", this.actualValue, timeFormat.format(this.timestamp));
    }

    public boolean equals(Object object) {
        return object == this || object instanceof CheckResult && this.equals((CheckResult)object);
    }

    private boolean equals(CheckResult that) {
        return this.verdict == that.verdict && Objects.equals(this.actualValue, that.actualValue);
    }

    public int hashCode() {
        return 31 * this.verdict.hashCode() + (this.actualValue == null ? 0 : this.actualValue.hashCode());
    }

    public static enum Verdict {
        ACCEPT,
        REJECT;

    }
}

