/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Clipboard;
import com.codeborne.selenide.Driver;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DefaultClipboard
implements Clipboard {
    private final Driver driver;

    public DefaultClipboard(Driver driver) {
        this.driver = driver;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public Driver driver() {
        return this.driver;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public Clipboard object() {
        return this;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String getText() {
        this.assertRemoteState();
        try {
            return Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor).toString();
        }
        catch (UnsupportedFlavorException | IOException e) {
            throw new IllegalStateException("Can't get clipboard data! " + e.getMessage(), e);
        }
    }

    @Override
    public void setText(String text) {
        this.assertRemoteState();
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(text), new StringSelection(text));
    }

    private void assertRemoteState() {
        if (this.driver.config().remote() != null) {
            throw new IllegalStateException("Remote driver url detected! Please use remote clipboard.");
        }
    }
}

