/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Command;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.commands.Util;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.WebElementSource;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class Matches
implements Command<Boolean> {
    @Override
    @CheckReturnValue
    public Boolean execute(SelenideElement proxy, WebElementSource locator, @Nullable Object[] args) {
        Condition condition = (Condition)Util.firstOf(args);
        WebElement element = this.getElementOrNull(locator);
        if (element != null) {
            return condition.check((Driver)locator.driver(), (WebElement)element).verdict == CheckResult.Verdict.ACCEPT;
        }
        return condition.missingElementSatisfiesCondition();
    }

    @CheckReturnValue
    @Nullable
    protected WebElement getElementOrNull(WebElementSource locator) {
        try {
            return locator.getWebElement();
        }
        catch (ElementNotFound | WebDriverException elementNotFound) {
            if (Cleanup.of.isInvalidSelectorError((Throwable)elementNotFound)) {
                throw Cleanup.of.wrapInvalidSelectorException((Throwable)elementNotFound);
            }
            return null;
        }
        catch (IndexOutOfBoundsException ignore) {
            return null;
        }
    }
}

