/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.Command;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.commands.UploadFile;
import com.codeborne.selenide.commands.Util;
import com.codeborne.selenide.impl.WebElementSource;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

@ParametersAreNonnullByDefault
public class UploadFileFromClasspath
implements Command<File> {
    UploadFile uploadFile = new UploadFile();

    @Override
    @CheckReturnValue
    @Nonnull
    public File execute(SelenideElement proxy, WebElementSource inputField, @Nullable Object[] args) throws IOException {
        String[] fileName = (String[])Util.firstOf(args);
        Object[] files = new File[fileName.length];
        for (int i = 0; i < fileName.length; ++i) {
            files[i] = this.findFileInClasspath(fileName[i]);
        }
        return this.uploadFile.execute(proxy, inputField, files);
    }

    @CheckReturnValue
    @Nonnull
    protected File findFileInClasspath(String name) {
        URL resource = Thread.currentThread().getContextClassLoader().getResource(name);
        if (resource == null) {
            throw new IllegalArgumentException("File not found in classpath: " + name);
        }
        try {
            URI uri = resource.toURI();
            return uri.isOpaque() ? this.saveAsTemporaryFile(resource) : new File(uri);
        }
        catch (IOException | URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private File saveAsTemporaryFile(URL classpathResource) throws IOException {
        Path directory = Files.createTempDirectory("selenide-upload-", new FileAttribute[0]);
        File fileToUpload = new File(directory.toFile().getAbsoluteFile(), FilenameUtils.getName((String)classpathResource.getFile()));
        FileUtils.copyURLToFile((URL)classpathResource, (File)fileToUpload);
        return fileToUpload;
    }
}

