/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class Attribute
extends Condition {
    private final String attributeName;

    public Attribute(String attributeName) {
        super("attribute");
        this.attributeName = attributeName;
    }

    @Override
    @Nonnull
    public CheckResult check(Driver driver, WebElement element) {
        String attributeValue = element.getAttribute(this.attributeName);
        return new CheckResult(attributeValue != null, (Object)String.format("%s=%s", this.attributeName, attributeValue));
    }

    @Override
    public String toString() {
        return this.getName() + " " + this.attributeName;
    }
}

