/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class CssValue
extends Condition {
    private final String propertyName;
    private final String expectedValue;

    public CssValue(String propertyName, @Nullable String expectedValue) {
        super("css value");
        this.propertyName = propertyName;
        this.expectedValue = expectedValue;
    }

    @Override
    @Nonnull
    public CheckResult check(Driver driver, WebElement element) {
        String actualCssValue = element.getCssValue(this.propertyName);
        boolean matches = StringUtils.defaultString((String)this.expectedValue).equalsIgnoreCase(StringUtils.defaultString((String)actualCssValue));
        return new CheckResult(matches, (Object)String.format("%s=%s", this.propertyName, actualCssValue));
    }

    @Override
    public String toString() {
        return this.getName() + " " + this.propertyName + '=' + this.expectedValue;
    }
}

