/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class ExplainedCondition
extends Condition {
    private final Condition delegate;
    private final String message;

    public ExplainedCondition(Condition delegate, String message) {
        super(delegate.getName(), delegate.missingElementSatisfiesCondition());
        this.delegate = delegate;
        this.message = message;
    }

    @Override
    @Nonnull
    public CheckResult check(Driver driver, WebElement element) {
        return this.delegate.check(driver, element);
    }

    @Override
    @Nonnull
    public Condition negate() {
        return this.delegate.negate().because(this.message);
    }

    @Override
    public String toString() {
        return this.delegate.toString() + " (because " + this.message + ")";
    }
}

