/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.ElementDescriber;
import com.codeborne.selenide.impl.Plugins;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class Focused
extends Condition {
    private final ElementDescriber describe = Plugins.inject(ElementDescriber.class);

    public Focused() {
        super("focused");
    }

    private WebElement getFocusedElement(Driver driver) {
        return (WebElement)driver.executeJavaScript("return document.activeElement", new Object[0]);
    }

    @Override
    @Nonnull
    public CheckResult check(Driver driver, WebElement webElement) {
        WebElement focusedElement = this.getFocusedElement(driver);
        boolean focused = focusedElement != null && focusedElement.equals(webElement);
        String description = focusedElement == null ? "No focused element found " : "Focused element: " + this.describe.briefly(driver, focusedElement) + ", current element: " + this.describe.briefly(driver, webElement);
        return new CheckResult(focused, (Object)description);
    }
}

