/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.conditions.Not;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class Hidden
extends Condition {
    public Hidden() {
        super("hidden", true);
    }

    @Override
    @Nonnull
    public CheckResult check(Driver driver, WebElement element) {
        try {
            boolean hidden = !element.isDisplayed();
            return new CheckResult(hidden, (Object)(hidden ? "hidden" : "visible"));
        }
        catch (StaleElementReferenceException elementHasDisappeared) {
            return new CheckResult(CheckResult.Verdict.ACCEPT, (Object)"hidden:true");
        }
    }

    @Override
    @Nonnull
    public Condition negate() {
        return new Not(this, false);
    }
}

