/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public abstract class TextCondition
extends Condition {
    private final String expectedText;

    protected TextCondition(String name, String expectedText) {
        super(name);
        this.expectedText = expectedText;
    }

    protected abstract boolean match(String var1, String var2);

    protected String getText(Driver driver, WebElement element) {
        return element.getText();
    }

    @Override
    @Nonnull
    public CheckResult check(Driver driver, WebElement element) {
        String elementText = this.getText(driver, element);
        return new CheckResult(this.match(elementText, this.expectedText), (Object)String.format("text=\"%s\"", elementText));
    }

    @Override
    public final String toString() {
        return String.format("%s \"%s\"", this.getName(), this.expectedText);
    }
}

