/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.drivercommands;

import com.codeborne.selenide.BrowserDownloadsFolder;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.DownloadsFolder;
import com.codeborne.selenide.drivercommands.SelenideDriverFinalCleanupThread;
import com.codeborne.selenide.impl.FileHelper;
import com.codeborne.selenide.impl.FileNamer;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import com.codeborne.selenide.webdriver.WebDriverFactory;
import java.io.File;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.internal.ShutdownHooks;
import org.openqa.selenium.support.events.EventFiringDecorator;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.openqa.selenium.support.events.WebDriverEventListener;
import org.openqa.selenium.support.events.WebDriverListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class CreateDriverCommand {
    private static final Logger log = LoggerFactory.getLogger(CreateDriverCommand.class);
    private final FileNamer fileNamer;

    public CreateDriverCommand() {
        this(new FileNamer());
    }

    CreateDriverCommand(FileNamer fileNamer) {
        this.fileNamer = fileNamer;
    }

    @Nonnull
    public Result createDriver(Config config, WebDriverFactory factory, @Nullable Proxy userProvidedProxy, List<WebDriverEventListener> eventListeners, List<WebDriverListener> listeners) {
        if (!config.reopenBrowserOnFail()) {
            throw new IllegalStateException("No webdriver is bound to current thread: " + Thread.currentThread().getId() + ", and cannot create a new webdriver because reopenBrowserOnFail=false");
        }
        SelenideProxyServer selenideProxyServer = null;
        Proxy browserProxy = userProvidedProxy;
        if (config.proxyEnabled()) {
            try {
                selenideProxyServer = new SelenideProxyServer(config, userProvidedProxy);
                selenideProxyServer.start();
                browserProxy = selenideProxyServer.createSeleniumProxy();
            }
            catch (NoClassDefFoundError e) {
                throw new IllegalStateException("Cannot initialize proxy. Probably you should add BrowserUpProxy dependency to your project - see https://search.maven.org/search?q=a:browserup-proxy-core", e);
            }
        }
        File browserDownloadsFolder = config.remote() != null ? null : FileHelper.ensureFolderExists(new File(config.downloadsFolder(), this.fileNamer.generateFileName()).getAbsoluteFile());
        WebDriver webdriver = factory.createWebDriver(config, browserProxy, browserDownloadsFolder);
        log.info("Create webdriver in current thread {}: {} -> {}", new Object[]{Thread.currentThread().getId(), webdriver.getClass().getSimpleName(), webdriver});
        WebDriver webDriver = this.addListeners(webdriver, eventListeners, listeners);
        ShutdownHooks.add((Thread)new Thread(new SelenideDriverFinalCleanupThread(config, webDriver, selenideProxyServer)));
        if (browserDownloadsFolder != null) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> FileHelper.deleteFolderIfEmpty(browserDownloadsFolder)));
        }
        return new Result(webDriver, selenideProxyServer, BrowserDownloadsFolder.from(browserDownloadsFolder));
    }

    @Nonnull
    private WebDriver addListeners(WebDriver webdriver, List<WebDriverEventListener> eventListeners, List<WebDriverListener> listeners) {
        return this.addWebDriverListeners(this.addEventListeners(webdriver, eventListeners), listeners);
    }

    @Nonnull
    private WebDriver addEventListeners(WebDriver webdriver, List<WebDriverEventListener> eventListeners) {
        if (eventListeners.isEmpty()) {
            return webdriver;
        }
        EventFiringWebDriver wrapper = new EventFiringWebDriver(webdriver);
        for (WebDriverEventListener listener : eventListeners) {
            log.info("Add listener to webdriver: {}", (Object)listener);
            wrapper.register(listener);
        }
        return wrapper;
    }

    @Nonnull
    private WebDriver addWebDriverListeners(WebDriver webdriver, List<WebDriverListener> listeners) {
        if (listeners.isEmpty()) {
            return webdriver;
        }
        log.info("Add listeners to webdriver: {}", listeners);
        EventFiringDecorator wrapper = new EventFiringDecorator(listeners.toArray(new WebDriverListener[0]));
        return wrapper.decorate(webdriver);
    }

    @ParametersAreNonnullByDefault
    public static class Result {
        public final WebDriver webDriver;
        @Nullable
        public final SelenideProxyServer selenideProxyServer;
        @Nullable
        public final DownloadsFolder browserDownloadsFolder;

        public Result(WebDriver webDriver, @Nullable SelenideProxyServer selenideProxyServer, @Nullable DownloadsFolder browserDownloadsFolder) {
            this.webDriver = webDriver;
            this.selenideProxyServer = selenideProxyServer;
            this.browserDownloadsFolder = browserDownloadsFolder;
        }
    }
}

