/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.ex;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ObjectCondition;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.DurationFormat;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class ErrorMessages {
    private static final DurationFormat df = new DurationFormat();

    @CheckReturnValue
    @Nonnull
    protected static String timeout(long timeoutMs) {
        return String.format("%nTimeout: %s", df.format(timeoutMs));
    }

    @CheckReturnValue
    @Nonnull
    static String actualValue(Condition condition, Driver driver, @Nullable WebElement element, @Nullable CheckResult lastCheckResult) {
        if (lastCheckResult != null && lastCheckResult.actualValue != null) {
            return String.format("%nActual value: %s", lastCheckResult.actualValue);
        }
        String actualValue = ErrorMessages.extractActualValue(condition, driver, element);
        if (actualValue != null) {
            return String.format("%nActual value: %s", actualValue);
        }
        return "";
    }

    @Nullable
    @CheckReturnValue
    private static String extractActualValue(Condition condition, Driver driver, @Nullable WebElement element) {
        if (element != null) {
            try {
                return condition.actualValue(driver, element);
            }
            catch (RuntimeException failedToGetValue) {
                String failedActualValue = failedToGetValue.getClass().getSimpleName() + ": " + failedToGetValue.getMessage();
                return StringUtils.substring((String)failedActualValue, (int)0, (int)50);
            }
        }
        return null;
    }

    @CheckReturnValue
    @Nonnull
    static <T> String actualValue(ObjectCondition<T> condition, @Nullable T object) {
        if (object == null) {
            return "";
        }
        return ErrorMessages.formatActualValue(ErrorMessages.extractActualValue(condition, object));
    }

    @CheckReturnValue
    @Nullable
    static <T> String extractActualValue(ObjectCondition<T> condition, @Nonnull T object) {
        try {
            return condition.actualValue(object);
        }
        catch (RuntimeException failedToGetValue) {
            String failedActualValue = failedToGetValue.getClass().getSimpleName() + ": " + failedToGetValue.getMessage();
            return StringUtils.substring((String)failedActualValue, (int)0, (int)50);
        }
    }

    @CheckReturnValue
    @Nonnull
    static <T> String formatActualValue(@Nullable String actualValue) {
        return actualValue == null ? "" : String.format("%nActual value: %s", actualValue);
    }

    @CheckReturnValue
    @Nonnull
    static String causedBy(@Nullable Throwable cause) {
        if (cause == null) {
            return "";
        }
        if (cause instanceof WebDriverException) {
            return String.format("%nCaused by: %s", Cleanup.of.webdriverExceptionMessage(cause));
        }
        return String.format("%nCaused by: %s", cause);
    }
}

