/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.impl.CollectionSource;
import com.codeborne.selenide.impl.SelenideElementProxy;
import com.codeborne.selenide.impl.WebElementSource;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class CollectionElement
extends WebElementSource {
    private final CollectionSource collection;
    private final int index;

    @CheckReturnValue
    @Nonnull
    public static SelenideElement wrap(CollectionSource collection, int index) {
        return (SelenideElement)Proxy.newProxyInstance(collection.getClass().getClassLoader(), new Class[]{SelenideElement.class}, (InvocationHandler)new SelenideElementProxy(new CollectionElement(collection, index)));
    }

    CollectionElement(CollectionSource collection, int index) {
        this.collection = collection;
        this.index = index;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public Driver driver() {
        return this.collection.driver();
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public WebElement getWebElement() {
        return this.collection.getElement(this.index);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String getSearchCriteria() {
        return this.collection.description() + '[' + this.index + ']';
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public ElementNotFound createElementNotFoundError(Condition condition, Throwable lastError) {
        if (this.collection.getElements().isEmpty()) {
            return new ElementNotFound(this.description(), Condition.visible, lastError);
        }
        return super.createElementNotFoundError(condition, lastError);
    }
}

