/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Screenshot {
    private final String image;
    private final String source;

    public Screenshot(@Nullable String image, @Nullable String source) {
        this.image = image;
        this.source = source;
    }

    @CheckReturnValue
    @Nullable
    public String getImage() {
        return this.image;
    }

    @CheckReturnValue
    @Nullable
    public String getSource() {
        return this.source;
    }

    @CheckReturnValue
    @Nonnull
    public static Screenshot none() {
        return new Screenshot(null, null);
    }

    public boolean isPresent() {
        return this.image != null || this.source != null;
    }

    public String summary() {
        if (this.image != null && this.source != null) {
            return String.format("%nScreenshot: %s%nPage source: %s", this.image, this.source);
        }
        if (this.source != null) {
            return String.format("%nPage source: %s", this.source);
        }
        if (this.image != null) {
            return String.format("%nScreenshot: %s", this.image);
        }
        return "";
    }

    public String toString() {
        return this.summary();
    }
}

