/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public abstract class AbstractChromiumDriverFactory
extends AbstractDriverFactory {
    private static final Logger log = LoggerFactory.getLogger(AbstractChromiumDriverFactory.class);
    private static final Pattern REGEX_COMMAS_IN_VALUES = Pattern.compile(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
    private static final Pattern REGEX_REMOVE_QUOTES = Pattern.compile("\"", 16);

    @Nonnull
    @CheckReturnValue
    protected List<String> createChromiumArguments(Config config, String externalArguments) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("--proxy-bypass-list=<-loopback>");
        arguments.add("--disable-dev-shm-usage");
        arguments.add("--no-sandbox");
        arguments.addAll(this.parseArguments(externalArguments));
        arguments.addAll(this.createHeadlessArguments(config));
        return arguments;
    }

    @Nonnull
    @CheckReturnValue
    protected Map<String, Object> prefs(@Nullable File browserDownloadsFolder, String externalPreferences) {
        HashMap<String, Object> preferences = new HashMap<String, Object>();
        preferences.put("safebrowsing.enabled", true);
        preferences.put("credentials_enable_service", false);
        preferences.put("plugins.always_open_pdf_externally", true);
        preferences.put("profile.default_content_setting_values.automatic_downloads", 1);
        if (browserDownloadsFolder != null) {
            preferences.put("download.default_directory", browserDownloadsFolder.getAbsolutePath());
        }
        preferences.putAll(this.parsePreferencesFromString(externalPreferences));
        log.debug("Using chromium preferences: {}", preferences);
        return preferences;
    }

    @Nonnull
    @CheckReturnValue
    protected List<String> createHeadlessArguments(Config config) {
        ArrayList<String> arguments = new ArrayList<String>();
        if (config.headless()) {
            arguments.add("--disable-background-networking");
            arguments.add("--enable-features=NetworkService,NetworkServiceInProcess");
            arguments.add("--disable-background-timer-throttling");
            arguments.add("--disable-backgrounding-occluded-windows");
            arguments.add("--disable-breakpad");
            arguments.add("--disable-client-side-phishing-detection");
            arguments.add("--disable-component-extensions-with-background-pages");
            arguments.add("--disable-default-apps");
            arguments.add("--disable-features=TranslateUI");
            arguments.add("--disable-hang-monitor");
            arguments.add("--disable-ipc-flooding-protection");
            arguments.add("--disable-popup-blocking");
            arguments.add("--disable-prompt-on-repost");
            arguments.add("--disable-renderer-backgrounding");
            arguments.add("--disable-sync");
            arguments.add("--force-color-profile=srgb");
            arguments.add("--metrics-recording-only");
            arguments.add("--no-first-run");
            arguments.add("--password-store=basic");
            arguments.add("--use-mock-keychain");
            arguments.add("--hide-scrollbars");
            arguments.add("--mute-audio");
        }
        return arguments;
    }

    @CheckReturnValue
    @Nonnull
    protected Map<String, Object> parsePreferencesFromString(String preferencesString) {
        HashMap<String, Object> prefs = new HashMap<String, Object>();
        List<String> allPrefs = this.parseCSV(preferencesString);
        for (String pref : allPrefs) {
            String[] keyValue = this.removeQuotes(pref).split("=");
            if (keyValue.length == 1) {
                log.warn("Missing '=' sign while parsing <key=value> pairs from {}. Key '{}' is ignored.", (Object)preferencesString, (Object)keyValue[0]);
                continue;
            }
            if (keyValue.length > 2) {
                log.warn("More than one '=' sign while parsing <key=value> pairs from {}. Key '{}' is ignored.", (Object)preferencesString, (Object)keyValue[0]);
                continue;
            }
            Object prefValue = this.convertStringToNearestObjectType(keyValue[1]);
            prefs.put(keyValue[0], prefValue);
        }
        return prefs;
    }

    @CheckReturnValue
    @Nonnull
    private List<String> parseArguments(String arguments) {
        return this.parseCSV(arguments).stream().map(this::removeQuotes).collect(Collectors.toList());
    }

    @CheckReturnValue
    @Nonnull
    final List<String> parseCSV(String csvString) {
        return StringUtils.isBlank((CharSequence)csvString) ? Collections.emptyList() : Arrays.asList(REGEX_COMMAS_IN_VALUES.split(csvString));
    }

    @CheckReturnValue
    @Nonnull
    private String removeQuotes(String value) {
        return REGEX_REMOVE_QUOTES.matcher(value).replaceAll(Matcher.quoteReplacement(""));
    }
}

