/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.webdriver.AbstractChromiumDriverFactory;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.File;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeDriverService;
import org.openqa.selenium.edge.EdgeOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class EdgeDriverFactory
extends AbstractChromiumDriverFactory {
    private static final Logger log = LoggerFactory.getLogger(EdgeDriverFactory.class);
    private static final int FIRST_VERSION_BASED_ON_CHROMIUM = 75;
    private static String browserVersion = null;

    @Override
    public void setupWebdriverBinary() {
        if (this.isSystemPropertyNotSet("webdriver.edge.driver")) {
            WebDriverManager manager = WebDriverManager.edgedriver();
            manager.setup();
            browserVersion = manager.getDownloadedDriverVersion();
        }
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public WebDriver create(Config config, Browser browser, @Nullable Proxy proxy, @Nullable File browserDownloadsFolder) {
        EdgeOptions options = this.createCapabilities(config, browser, proxy, browserDownloadsFolder);
        EdgeDriverService driverService = this.createDriverService(config);
        return new EdgeDriver(driverService, options);
    }

    private EdgeDriverService createDriverService(Config config) {
        return (EdgeDriverService)this.withLog(config, new EdgeDriverService.Builder());
    }

    @CheckReturnValue
    @Nonnull
    public EdgeOptions createCapabilities(Config config, Browser browser, @Nullable Proxy proxy, @Nullable File browserDownloadsFolder) {
        MutableCapabilities capabilities = this.createCommonCapabilities(config, browser, proxy);
        if (this.isChromiumBased()) {
            capabilities.setCapability("acceptInsecureCerts", true);
        }
        EdgeOptions options = new EdgeOptions().merge((Capabilities)capabilities);
        options.setHeadless(config.headless());
        if (!config.browserBinary().isEmpty()) {
            log.info("Using browser binary: {}", (Object)config.browserBinary());
            log.warn("Changing browser binary not supported in Edge, setting will be ignored.");
        }
        if (this.isChromiumBased()) {
            options.addArguments(this.createEdgeArguments(config));
            options.setExperimentalOption("prefs", this.prefs(browserDownloadsFolder, System.getProperty("edgeoptions.prefs", "")));
        }
        return options;
    }

    @CheckReturnValue
    @Nonnull
    protected List<String> createEdgeArguments(Config config) {
        return this.createChromiumArguments(config, System.getProperty("edgeoptions.args"));
    }

    @CheckReturnValue
    private boolean isChromiumBased() {
        return browserVersion == null || this.majorVersion(browserVersion) >= 75;
    }
}

