/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.ClickMethod;
import com.codeborne.selenide.commands.Util;
import com.codeborne.selenide.impl.HasTimeout;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.Keys;

public class ClickOptions
implements HasTimeout {
    private final int offsetX;
    private final int offsetY;
    private final ClickMethod clickMethod;
    private final @Nullable Duration timeout;
    private final boolean force;
    private final List<Keys> holdingKeys;

    protected ClickOptions(ClickMethod clickMethod, int offsetX, int offsetY, @Nullable Duration timeout, boolean force, List<Keys> holdingKeys) {
        this.clickMethod = clickMethod;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.timeout = timeout;
        this.force = force;
        this.holdingKeys = holdingKeys;
    }

    public static ClickOptions using(ClickMethod method) {
        return new ClickOptions(method, 0, 0, null, false, Collections.emptyList());
    }

    public static ClickOptions usingDefaultMethod() {
        return ClickOptions.using(ClickMethod.DEFAULT);
    }

    public static ClickOptions usingJavaScript() {
        return ClickOptions.using(ClickMethod.JS);
    }

    public static ClickOptions withOffset(int offsetX, int offsetY) {
        return new ClickOptions(ClickMethod.DEFAULT, offsetX, offsetY, null, false, Collections.emptyList());
    }

    public static ClickOptions withTimeout(Duration timeout) {
        return new ClickOptions(ClickMethod.DEFAULT, 0, 0, timeout, false, Collections.emptyList());
    }

    public int offsetX() {
        return this.offsetX;
    }

    public int offsetY() {
        return this.offsetY;
    }

    public ClickMethod clickMethod() {
        return this.clickMethod;
    }

    @Override
    public @Nullable Duration timeout() {
        return this.timeout;
    }

    public boolean isForce() {
        return this.force;
    }

    public List<Keys> holdingKeys() {
        return this.holdingKeys;
    }

    public ClickOptions offsetX(int offsetX) {
        return new ClickOptions(this.clickMethod, offsetX, this.offsetY, this.timeout, this.force, this.holdingKeys);
    }

    public ClickOptions offsetY(int offsetY) {
        return new ClickOptions(this.clickMethod, this.offsetX, offsetY, this.timeout, this.force, this.holdingKeys);
    }

    public ClickOptions offset(int offsetX, int offsetY) {
        return new ClickOptions(this.clickMethod, offsetX, offsetY, this.timeout, this.force, this.holdingKeys);
    }

    public ClickOptions timeout(Duration timeout) {
        return new ClickOptions(this.clickMethod, this.offsetX, this.offsetY, timeout, this.force, this.holdingKeys);
    }

    public ClickOptions force() {
        return new ClickOptions(this.clickMethod, this.offsetX, this.offsetY, this.timeout, true, this.holdingKeys);
    }

    public ClickOptions holdingKeys(Keys holdingKeys, Keys ... otherKeys) {
        return new ClickOptions(this.clickMethod, this.offsetX, this.offsetY, this.timeout, this.force, Util.merge(holdingKeys, otherKeys));
    }

    public String toString() {
        if (this.hasDefaultParameters()) {
            return String.format("method: %s", new Object[]{this.clickMethod});
        }
        if (this.timeout == null) {
            return String.format("method: %s, offsetX: %s, offsetY: %s, force: %s, keys: %s", new Object[]{this.clickMethod, this.offsetX, this.offsetY, this.force, this.keysToString()});
        }
        return String.format("method: %s, offsetX: %s, offsetY: %s, timeout: %s, force: %s, keys: %s", new Object[]{this.clickMethod, this.offsetX, this.offsetY, this.timeout, this.force, this.keysToString()});
    }

    private boolean hasDefaultParameters() {
        return this.offsetX == 0 && this.offsetY == 0 && !this.force && this.timeout == null && this.holdingKeys.isEmpty();
    }

    private String keysToString() {
        return this.holdingKeys.stream().map(this::keyToString).toList().toString();
    }

    private String keyToString(Keys key) {
        return switch (key) {
            case Keys.ALT -> "alt";
            case Keys.LEFT_ALT -> "left alt";
            case Keys.CONTROL -> "control";
            case Keys.LEFT_CONTROL -> "left control";
            case Keys.SHIFT -> "shift";
            case Keys.LEFT_SHIFT -> "left shift";
            case Keys.META -> "meta";
            default -> key.toString();
        };
    }
}

