/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.conditions.And;
import com.codeborne.selenide.conditions.Animated;
import com.codeborne.selenide.conditions.Attribute;
import com.codeborne.selenide.conditions.AttributeWithValue;
import com.codeborne.selenide.conditions.CaseSensitiveText;
import com.codeborne.selenide.conditions.Checked;
import com.codeborne.selenide.conditions.ConditionHelpers;
import com.codeborne.selenide.conditions.CssClass;
import com.codeborne.selenide.conditions.CssValue;
import com.codeborne.selenide.conditions.CustomMatch;
import com.codeborne.selenide.conditions.Disabled;
import com.codeborne.selenide.conditions.DomAttribute;
import com.codeborne.selenide.conditions.DomAttributeValue;
import com.codeborne.selenide.conditions.DomProperty;
import com.codeborne.selenide.conditions.DomPropertyValue;
import com.codeborne.selenide.conditions.Editable;
import com.codeborne.selenide.conditions.Enabled;
import com.codeborne.selenide.conditions.ExactOwnText;
import com.codeborne.selenide.conditions.ExactOwnTextCaseSensitive;
import com.codeborne.selenide.conditions.ExactText;
import com.codeborne.selenide.conditions.ExactTextCaseSensitive;
import com.codeborne.selenide.conditions.Exist;
import com.codeborne.selenide.conditions.Focused;
import com.codeborne.selenide.conditions.Hidden;
import com.codeborne.selenide.conditions.Href;
import com.codeborne.selenide.conditions.InnerText;
import com.codeborne.selenide.conditions.Interactable;
import com.codeborne.selenide.conditions.IsImageLoaded;
import com.codeborne.selenide.conditions.MatchAttributeWithValue;
import com.codeborne.selenide.conditions.MatchText;
import com.codeborne.selenide.conditions.NamedCondition;
import com.codeborne.selenide.conditions.OneOfExactTexts;
import com.codeborne.selenide.conditions.OneOfExactTextsCaseSensitive;
import com.codeborne.selenide.conditions.OneOfTexts;
import com.codeborne.selenide.conditions.OneOfTextsCaseSensitive;
import com.codeborne.selenide.conditions.Or;
import com.codeborne.selenide.conditions.OwnText;
import com.codeborne.selenide.conditions.OwnTextCaseSensitive;
import com.codeborne.selenide.conditions.PartialText;
import com.codeborne.selenide.conditions.PartialTextCaseSensitive;
import com.codeborne.selenide.conditions.PartialValue;
import com.codeborne.selenide.conditions.PseudoElementPropertyWithValue;
import com.codeborne.selenide.conditions.Readonly;
import com.codeborne.selenide.conditions.Selected;
import com.codeborne.selenide.conditions.SelectedText;
import com.codeborne.selenide.conditions.TagName;
import com.codeborne.selenide.conditions.Text;
import com.codeborne.selenide.conditions.Value;
import com.codeborne.selenide.conditions.Visible;
import java.util.Arrays;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.WebElement;

public final class Condition {
    public static final WebElementCondition visible = new Visible();
    public static final WebElementCondition exist = new Exist();
    public static final WebElementCondition hidden = new Hidden();
    public static final WebElementCondition appear = Condition.be(visible);
    public static final WebElementCondition disappear = Condition.be(hidden);
    public static final WebElementCondition interactable = new Interactable();
    public static final WebElementCondition readonly = new Readonly();
    public static final WebElementCondition editable = new Editable();
    public static final WebElementCondition animated = new Animated();
    public static final WebElementCondition empty = Condition.and("empty", Condition.exactValue(""), Condition.exactText(""), new WebElementCondition[0]);
    public static final WebElementCondition image = new IsImageLoaded();
    public static final WebElementCondition focused = new Focused();
    public static final WebElementCondition enabled = new Enabled();
    public static final WebElementCondition disabled = new Disabled();
    public static final WebElementCondition selected = new Selected();
    public static final WebElementCondition checked = new Checked();
    public static final WebElementCondition clickable = Condition.and("clickable", interactable, enabled, new WebElementCondition[0]);

    public static WebElementCondition attribute(String attributeName) {
        return new Attribute(attributeName);
    }

    public static WebElementCondition attribute(String attributeName, String expectedAttributeValue) {
        return new AttributeWithValue(attributeName, expectedAttributeValue);
    }

    public static WebElementCondition attributeMatching(String attributeName, String attributeRegex) {
        return new MatchAttributeWithValue(attributeName, attributeRegex);
    }

    public static WebElementCondition href(String href) {
        return new Href(href);
    }

    public static WebElementCondition value(String expectedValue) {
        return new Value(expectedValue);
    }

    public static WebElementCondition partialValue(String expectedValue) {
        return new PartialValue(expectedValue);
    }

    public static WebElementCondition pseudo(String pseudoElementName, String propertyName, String expectedValue) {
        return new PseudoElementPropertyWithValue(pseudoElementName, propertyName, expectedValue);
    }

    public static WebElementCondition pseudo(String pseudoElementName, String expectedValue) {
        return new PseudoElementPropertyWithValue(pseudoElementName, "content", expectedValue);
    }

    public static WebElementCondition exactValue(String value) {
        return Condition.attribute("value", value);
    }

    public static WebElementCondition name(String name) {
        return Condition.attribute("name", name);
    }

    public static WebElementCondition type(String type) {
        return Condition.attribute("type", type);
    }

    public static WebElementCondition id(String id) {
        return Condition.attribute("id", id);
    }

    public static WebElementCondition matchText(String regex) {
        return new MatchText(regex);
    }

    public static WebElementCondition oneOfTexts(String ... texts) {
        return new OneOfTexts(Arrays.asList(texts));
    }

    public static WebElementCondition oneOfTextsCaseSensitive(String ... texts) {
        return new OneOfTextsCaseSensitive(Arrays.asList(texts));
    }

    public static WebElementCondition oneOfExactTexts(String ... texts) {
        return new OneOfExactTexts(Arrays.asList(texts));
    }

    public static WebElementCondition oneOfExactTextsCaseSensitive(String ... texts) {
        return new OneOfExactTextsCaseSensitive(Arrays.asList(texts));
    }

    public static WebElementCondition partialText(String expectedText) {
        return new PartialText(expectedText);
    }

    public static WebElementCondition partialTextCaseSensitive(String expectedText) {
        return new PartialTextCaseSensitive(expectedText);
    }

    public static WebElementCondition text(String text) {
        return new Text(text);
    }

    public static WebElementCondition selectedText(String expectedText) {
        return new SelectedText(expectedText);
    }

    public static WebElementCondition textCaseSensitive(String text) {
        return new CaseSensitiveText(text);
    }

    public static WebElementCondition exactText(String text) {
        return new ExactText(text);
    }

    public static WebElementCondition innerText(String text) {
        return new InnerText(text);
    }

    public static WebElementCondition ownText(String text) {
        return new OwnText(text);
    }

    public static WebElementCondition ownTextCaseSensitive(String text) {
        return new OwnTextCaseSensitive(text);
    }

    public static WebElementCondition exactOwnText(String text) {
        return new ExactOwnText(text);
    }

    public static WebElementCondition exactOwnTextCaseSensitive(String text) {
        return new ExactOwnTextCaseSensitive(text);
    }

    public static WebElementCondition exactTextCaseSensitive(String text) {
        return new ExactTextCaseSensitive(text);
    }

    public static WebElementCondition tagName(String cssClass) {
        return new TagName(cssClass);
    }

    public static WebElementCondition cssClass(String cssClass) {
        return new CssClass(cssClass);
    }

    public static WebElementCondition cssValue(String propertyName, @Nullable String expectedValue) {
        return new CssValue(propertyName, expectedValue);
    }

    public static WebElementCondition domAttribute(String domAttributeName) {
        return new DomAttribute(domAttributeName);
    }

    public static WebElementCondition domAttribute(String domAttributeName, @Nullable String expectedDomAttributeValue) {
        return new DomAttributeValue(domAttributeName, expectedDomAttributeValue);
    }

    public static WebElementCondition domProperty(String domPropertyName) {
        return new DomProperty(domPropertyName);
    }

    public static WebElementCondition domProperty(String domPropertyName, @Nullable String expectedDomPropertyValue) {
        return new DomPropertyValue(domPropertyName, expectedDomPropertyValue);
    }

    public static WebElementCondition match(String description, Predicate<WebElement> predicate) {
        return new CustomMatch(description, predicate);
    }

    public static WebElementCondition not(WebElementCondition condition) {
        return condition.negate();
    }

    public static WebElementCondition and(String name, WebElementCondition condition1, WebElementCondition condition2, WebElementCondition ... conditions) {
        return new And(name, ConditionHelpers.merge(condition1, condition2, conditions));
    }

    public static WebElementCondition allOf(String name, WebElementCondition condition1, WebElementCondition condition2, WebElementCondition ... conditions) {
        return Condition.and(name, condition1, condition2, conditions);
    }

    public static WebElementCondition allOf(WebElementCondition condition1, WebElementCondition condition2, WebElementCondition ... conditions) {
        return Condition.and("all of", condition1, condition2, conditions);
    }

    public static WebElementCondition or(String name, WebElementCondition condition1, WebElementCondition condition2, WebElementCondition ... conditions) {
        return new Or(name, ConditionHelpers.merge(condition1, condition2, conditions));
    }

    public static WebElementCondition anyOf(String name, WebElementCondition condition1, WebElementCondition condition2, WebElementCondition ... conditions) {
        return Condition.or(name, condition1, condition2, conditions);
    }

    public static WebElementCondition anyOf(WebElementCondition condition1, WebElementCondition condition2, WebElementCondition ... conditions) {
        return Condition.or("any of", condition1, condition2, conditions);
    }

    public static WebElementCondition be(WebElementCondition delegate) {
        return Condition.wrap("be", delegate);
    }

    public static WebElementCondition have(WebElementCondition delegate) {
        return Condition.wrap("have", delegate);
    }

    private static WebElementCondition wrap(String prefix, WebElementCondition delegate) {
        return new NamedCondition(prefix, delegate);
    }
}

