/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.FileDownloadMode;
import com.codeborne.selenide.files.DownloadAction;
import com.codeborne.selenide.files.DownloadActions;
import com.codeborne.selenide.files.FileFilter;
import com.codeborne.selenide.files.FileFilters;
import com.codeborne.selenide.impl.HasTimeout;
import java.time.Duration;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;

public class DownloadOptions
implements HasTimeout {
    private final @Nullable FileDownloadMode method;
    private final @Nullable Duration timeout;
    private final @Nullable Duration incrementTimeout;
    private final FileFilter filter;
    private final DownloadAction action;

    private DownloadOptions(@Nullable FileDownloadMode method, @Nullable Duration timeout, @Nullable Duration incrementTimeout, FileFilter filter, DownloadAction action) {
        this.method = method;
        this.timeout = timeout;
        this.incrementTimeout = incrementTimeout;
        this.filter = filter;
        this.action = action;
    }

    public @Nullable FileDownloadMode getMethod() {
        return this.method;
    }

    @Override
    public @Nullable Duration timeout() {
        return this.timeout;
    }

    public @Nullable Duration incrementTimeout() {
        return this.incrementTimeout;
    }

    public FileFilter getFilter() {
        return this.filter;
    }

    public DownloadAction getAction() {
        return this.action;
    }

    public DownloadOptions withMethod(FileDownloadMode method) {
        return new DownloadOptions(method, this.timeout, this.incrementTimeout, this.filter, this.action);
    }

    public DownloadOptions withTimeout(long timeoutMs) {
        return new DownloadOptions(this.method, Duration.ofMillis(timeoutMs), this.incrementTimeout, this.filter, this.action);
    }

    public DownloadOptions withTimeout(Duration timeout) {
        return new DownloadOptions(this.method, timeout, this.incrementTimeout, this.filter, this.action);
    }

    public DownloadOptions withIncrementTimeout(Duration incrementTimeout) {
        return new DownloadOptions(this.method, this.timeout, incrementTimeout, this.filter, this.action);
    }

    public DownloadOptions withFilter(FileFilter filter) {
        return new DownloadOptions(this.method, this.timeout, this.incrementTimeout, filter, this.action);
    }

    public DownloadOptions withExtension(String extension) {
        return new DownloadOptions(this.method, this.timeout, this.incrementTimeout, FileFilters.withExtension(extension), this.action);
    }

    public DownloadOptions withName(String fileName) {
        return new DownloadOptions(this.method, this.timeout, this.incrementTimeout, FileFilters.withName(fileName), this.action);
    }

    public DownloadOptions withNameMatching(String fileNameRegex) {
        return new DownloadOptions(this.method, this.timeout, this.incrementTimeout, FileFilters.withNameMatching(fileNameRegex), this.action);
    }

    public DownloadOptions withAction(DownloadAction action) {
        return new DownloadOptions(this.method, this.timeout, this.incrementTimeout, this.filter, action);
    }

    public String toString() {
        return Stream.of(this.method == null ? null : "method: %s".formatted(this.method.name()), this.timeout == null ? null : "timeout: %s ms".formatted(this.timeout.toMillis()), this.incrementTimeout == null ? null : "incrementTimeout: %s ms".formatted(this.incrementTimeout.toMillis()), this.filter.isEmpty() ? null : this.filter.toString()).filter(p -> p != null).collect(Collectors.joining(", "));
    }

    public static DownloadOptions file() {
        return new DownloadOptions(null, null, null, FileFilters.none(), DownloadActions.click());
    }

    public static DownloadOptions using(FileDownloadMode method) {
        return DownloadOptions.file().withMethod(method);
    }
}

