/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.JavaScript;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Describe {
    private static final Logger log = LoggerFactory.getLogger(Describe.class);
    private final JavaScript js = new JavaScript("get-element-attributes.js");
    private final Driver driver;
    private final WebElement element;
    private final StringBuilder sb = new StringBuilder();

    public Describe(Driver driver, WebElement element) {
        this.driver = driver;
        this.element = element;
        this.sb.append('<').append(element.getTagName());
    }

    public Describe appendAttributes() {
        block4: {
            try {
                if (this.supportsJavascriptAttributes()) {
                    return this.appendAllAttributes();
                }
            }
            catch (UnsupportedOperationException | NoSuchElementException | StaleElementReferenceException | UnsupportedCommandException throwable) {
            }
            catch (WebDriverException probablyBrowserDoesNotSupportJavaScript) {
                if (probablyBrowserDoesNotSupportJavaScript.getMessage().toLowerCase(Locale.ROOT).contains("method is not implemented")) break block4;
                log.warn("Failed to get attributes via JS: {}", (Object)probablyBrowserDoesNotSupportJavaScript.toString());
            }
        }
        return this.appendPredefinedAttributes();
    }

    private Describe appendAllAttributes() {
        Map map = Objects.requireNonNull((Map)this.js.execute(this.driver, this.element));
        TreeMap sortedByName = new TreeMap(map);
        for (Map.Entry entry : sortedByName.entrySet()) {
            this.attr((String)entry.getKey(), (String)entry.getValue());
        }
        return this;
    }

    private Describe appendPredefinedAttributes() {
        return this.attr("class").attr("disabled").attr("readonly").attr("href").attr("id").attr("name").attr("onclick").attr("onchange").attr("placeholder").attr("type").attr("value");
    }

    private boolean supportsJavascriptAttributes() {
        return this.driver.supportsJavascript();
    }

    public Describe attr(String attributeName) {
        try {
            String attributeValue = this.element.getAttribute(attributeName);
            return this.attr(attributeName, attributeValue);
        }
        catch (UnsupportedOperationException | NoSuchElementException | StaleElementReferenceException | UnsupportedCommandException browserDoesNotSupportJavaScript) {
            return this;
        }
        catch (WebDriverException probablyBrowserDoesNotSupportJavaScript) {
            if (!probablyBrowserDoesNotSupportJavaScript.getMessage().toLowerCase(Locale.ROOT).contains("method is not implemented")) {
                log.warn("Failed to get attribute {}: {}", (Object)attributeName, (Object)probablyBrowserDoesNotSupportJavaScript.toString());
            }
            return this;
        }
    }

    @CanIgnoreReturnValue
    private Describe attr(String attributeName, @Nullable String attributeValue) {
        if (attributeValue != null) {
            if (!attributeValue.isEmpty()) {
                this.sb.append(' ').append(attributeName).append("=\"").append(attributeValue).append('\"');
            } else {
                this.sb.append(' ').append(attributeName);
            }
        }
        return this;
    }

    public String serialize() {
        String text = this.safeCall("text", () -> ((WebElement)this.element).getText());
        this.sb.append('>').append(text == null ? "" : text).append("</").append(this.safeCall("tagName", () -> ((WebElement)this.element).getTagName())).append('>');
        return this.sb.toString();
    }

    public String toString() {
        return this.sb.toString();
    }

    public String flush() {
        return this.sb.append('>').toString();
    }

    public Describe isSelected(WebElement element) {
        try {
            if (element.isSelected()) {
                this.sb.append(' ').append("selected:true");
            }
        }
        catch (UnsupportedOperationException | WebDriverException throwable) {
            // empty catch block
        }
        return this;
    }

    public Describe isDisplayed(WebElement element) {
        try {
            if (!element.isDisplayed()) {
                this.sb.append(' ').append("displayed:false");
            }
        }
        catch (UnsupportedOperationException | WebDriverException e) {
            log.debug("Failed to check visibility", e);
            this.sb.append(' ').append("displayed:").append(Cleanup.of.webdriverExceptionMessage(e));
        }
        catch (RuntimeException e) {
            log.error("Failed to check visibility", (Throwable)e);
            this.sb.append(' ').append("displayed:").append(Cleanup.of.webdriverExceptionMessage(e));
        }
        return this;
    }

    private String safeCall(String name, Supplier<String> method) {
        try {
            return method.get();
        }
        catch (WebDriverException e) {
            log.debug("Failed to get {}", (Object)name, (Object)e);
            return Cleanup.of.webdriverExceptionMessage(e);
        }
        catch (RuntimeException e) {
            log.error("Failed to get {}", (Object)name, (Object)e);
            return "?";
        }
    }
}

