/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.selector;

import com.codeborne.selenide.selector.ByShadow;
import java.io.Serializable;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class ByDeepShadow
extends By
implements Serializable {
    private final By target;

    public ByDeepShadow(By target) {
        if (target == null) {
            throw new IllegalArgumentException("Cannot find elements when the selector is null");
        }
        this.target = target;
    }

    public WebElement findElement(SearchContext context) {
        List<WebElement> elements = ByDeepShadow.findElements(context, this.target, false);
        if (elements.isEmpty()) {
            throw new NoSuchElementException("Cannot locate an element in shadow dom " + String.valueOf(this));
        }
        return elements.get(0);
    }

    public List<WebElement> findElements(SearchContext context) {
        return ByDeepShadow.findElements(context, this.target, true);
    }

    private static List<WebElement> findElements(SearchContext context, By target, boolean findAll) {
        List result = context.findElements(target);
        if (!result.isEmpty() && !findAll) {
            return result;
        }
        List<SearchContext> shadowRoots = ByDeepShadow.findShadowRoots(context);
        for (SearchContext shadowRoot : shadowRoots) {
            List<WebElement> elements = ByDeepShadow.findElements(shadowRoot, target, findAll);
            if (elements.isEmpty()) continue;
            if (!findAll) {
                return elements;
            }
            result.addAll(elements);
        }
        return result;
    }

    private static List<SearchContext> findShadowRoots(SearchContext context) {
        return ByShadow.findShadowRoots(context, By.cssSelector((String)"*"));
    }

    public String toString() {
        return "By.shadowDeep: " + String.valueOf(this.target);
    }
}

