/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.Stopwatch;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.WebElementsCondition;
import com.codeborne.selenide.commands.Util;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.ex.UIAssertionError;
import com.codeborne.selenide.impl.BySelectorCollection;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.CollectionElement;
import com.codeborne.selenide.impl.CollectionElementByCondition;
import com.codeborne.selenide.impl.CollectionSnapshot;
import com.codeborne.selenide.impl.CollectionSource;
import com.codeborne.selenide.impl.ElementCommunicator;
import com.codeborne.selenide.impl.FilteringCollection;
import com.codeborne.selenide.impl.HeadOfCollection;
import com.codeborne.selenide.impl.LastCollectionElement;
import com.codeborne.selenide.impl.Plugins;
import com.codeborne.selenide.impl.SelenideElementIterator;
import com.codeborne.selenide.impl.TailOfCollection;
import com.codeborne.selenide.impl.WebElementsCollectionWrapper;
import com.codeborne.selenide.logevents.ErrorsCollector;
import com.codeborne.selenide.logevents.LogEvent;
import com.codeborne.selenide.logevents.SelenideLog;
import com.codeborne.selenide.logevents.SelenideLogger;
import java.time.Duration;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public abstract class BaseElementsCollection<T extends SelenideElement, SELF extends BaseElementsCollection<T, SELF>>
implements Iterable<T> {
    private static final ElementCommunicator communicator = Plugins.inject(ElementCommunicator.class);
    private final Class<T> clazz;
    private final CollectionSource collection;

    @SafeVarargs
    protected BaseElementsCollection(CollectionSource collection, T ... clazz) {
        this.clazz = Util.classOf(clazz);
        this.collection = collection;
    }

    @SafeVarargs
    protected BaseElementsCollection(Driver driver, Collection<? extends WebElement> elements, T ... clazz) {
        this(new WebElementsCollectionWrapper(driver, elements), (SelenideElement[])clazz);
    }

    @SafeVarargs
    protected BaseElementsCollection(Driver driver, String cssSelector, T ... clazz) {
        this(driver, By.cssSelector((String)cssSelector), (SelenideElement[])clazz);
    }

    @SafeVarargs
    protected BaseElementsCollection(Driver driver, By seleniumSelector, T ... clazz) {
        this(new BySelectorCollection(driver, seleniumSelector), (SelenideElement[])clazz);
    }

    @Nonnull
    public SELF should(WebElementsCondition ... conditions) {
        return this.should("", Duration.ofMillis(this.driver().config().timeout()), conditions);
    }

    @Nonnull
    public SELF should(WebElementsCondition condition, Duration timeout) {
        return this.should("", timeout, this.toArray(condition));
    }

    @Nonnull
    public SELF shouldBe(WebElementsCondition ... conditions) {
        return this.should("be", Duration.ofMillis(this.driver().config().timeout()), conditions);
    }

    @Nonnull
    public SELF shouldBe(WebElementsCondition condition, Duration timeout) {
        return this.should("be", timeout, this.toArray(condition));
    }

    @Nonnull
    public SELF shouldHave(WebElementsCondition ... conditions) {
        return this.should("have", Duration.ofMillis(this.driver().config().timeout()), conditions);
    }

    @Nonnull
    public SELF shouldHave(WebElementsCondition condition, Duration timeout) {
        return this.should("have", timeout, this.toArray(condition));
    }

    @CheckReturnValue
    @Nonnull
    private WebElementsCondition[] toArray(WebElementsCondition condition) {
        return new WebElementsCondition[]{condition};
    }

    @Nonnull
    protected SELF should(String prefix, Duration timeout, WebElementsCondition ... conditions) {
        ErrorsCollector.validateAssertionMode(this.driver().config());
        SelenideLog log = SelenideLogger.beginStep(this.collection.shortDescription(), "should " + prefix, conditions);
        try {
            for (WebElementsCondition condition : conditions) {
                this.waitUntil(condition, timeout);
            }
            SelenideLogger.commitStep(log, LogEvent.EventStatus.PASS);
            return this.self();
        }
        catch (Error error) {
            Error wrappedError = UIAssertionError.wrap(this.driver(), error, timeout.toMillis());
            SelenideLogger.commitStep(log, wrappedError);
            switch (this.driver().config().assertionMode()) {
                case SOFT: {
                    break;
                }
                default: {
                    throw wrappedError;
                }
            }
            return this.self();
        }
        catch (RuntimeException e) {
            SelenideLogger.commitStep(log, e);
            throw e;
        }
    }

    @Nonnull
    private SELF self() {
        return (SELF)this;
    }

    protected void waitUntil(WebElementsCondition condition, Duration timeout) {
        Object lastError = null;
        CheckResult lastCheckResult = new CheckResult(CheckResult.Verdict.REJECT, null);
        Stopwatch stopwatch = new Stopwatch(timeout.toMillis());
        do {
            try {
                lastCheckResult = condition.check(this.collection);
                if (lastCheckResult.verdict() == CheckResult.Verdict.ACCEPT) {
                    return;
                }
            }
            catch (JavascriptException | UnsupportedCommandException e) {
                throw e;
            }
            catch (UIAssertionError | IndexOutOfBoundsException | WebDriverException elementNotFound) {
                if (Cleanup.of.isInvalidSelectorError((Throwable)elementNotFound)) {
                    throw Cleanup.of.wrapInvalidSelectorException((Throwable)elementNotFound);
                }
                if (condition.missingElementsSatisfyCondition()) {
                    return;
                }
                lastError = elementNotFound;
            }
            this.sleep(this.driver().config().pollingInterval());
        } while (!stopwatch.isTimeoutReached());
        if (lastError instanceof IndexOutOfBoundsException) {
            throw new ElementNotFound(this.collection.driver(), this.collection.getAlias(), this.collection.description(), Condition.exist, (Throwable)lastError);
        }
        if (lastError instanceof UIAssertionError) {
            UIAssertionError uiAssertionError = (UIAssertionError)((Object)lastError);
            throw uiAssertionError;
        }
        condition.fail(this.collection, lastCheckResult, (Exception)lastError, timeout.toMillis());
    }

    void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @CheckReturnValue
    @Nonnull
    public SELF filter(WebElementCondition condition) {
        return this.create(new FilteringCollection(this.collection, condition));
    }

    protected abstract SELF create(CollectionSource var1);

    @CheckReturnValue
    @Nonnull
    public SELF filterBy(WebElementCondition condition) {
        return this.filter(condition);
    }

    @CheckReturnValue
    @Nonnull
    public SELF exclude(WebElementCondition condition) {
        return this.create(new FilteringCollection(this.collection, Condition.not(condition)));
    }

    @CheckReturnValue
    @Nonnull
    public SELF excludeWith(WebElementCondition condition) {
        return this.exclude(condition);
    }

    @CheckReturnValue
    @Nonnull
    public SelenideElement find(WebElementCondition condition) {
        return CollectionElementByCondition.wrap(this.collection, condition);
    }

    @CheckReturnValue
    @Nonnull
    public SelenideElement findBy(WebElementCondition condition) {
        return this.find(condition);
    }

    @CheckReturnValue
    @Nonnull
    private List<WebElement> getElements() {
        return this.collection.getElements();
    }

    @CheckReturnValue
    @Nonnull
    public List<String> texts() {
        return communicator.texts(this.driver(), this.getElements());
    }

    @CheckReturnValue
    @Nonnull
    public List<String> attributes(String attribute) {
        return communicator.attributes(this.driver(), this.getElements(), attribute);
    }

    @CheckReturnValue
    @Nonnull
    public T get(int index) {
        return CollectionElement.wrap(this.clazz, this.collection, index);
    }

    @CheckReturnValue
    @Nonnull
    public SelenideElement first() {
        return this.get(0);
    }

    @CheckReturnValue
    @Nonnull
    public SelenideElement last() {
        return LastCollectionElement.wrap(this.collection);
    }

    @CheckReturnValue
    @Nonnull
    public SELF first(int elements) {
        return this.create(new HeadOfCollection(this.collection, elements));
    }

    @CheckReturnValue
    @Nonnull
    public SELF last(int elements) {
        return this.create(new TailOfCollection(this.collection, elements));
    }

    @CheckReturnValue
    public int size() {
        try {
            return this.getElements().size();
        }
        catch (IndexOutOfBoundsException outOfCollection) {
            return 0;
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @CheckReturnValue
    @Nonnull
    public SELF snapshot() {
        return this.create(new CollectionSnapshot(this.collection));
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public Iterator<T> iterator() {
        return this.asFixedIterable().iterator();
    }

    @CheckReturnValue
    @Nonnull
    public SelenideElementIterable<T> asFixedIterable() {
        return () -> new SelenideElementIterator((CollectionSource)new CollectionSnapshot(this.collection), new SelenideElement[0]);
    }

    @CheckReturnValue
    @Nonnull
    public SelenideElementIterable<T> asDynamicIterable() {
        return () -> new SelenideElementIterator(this.collection, new SelenideElement[0]);
    }

    @CheckReturnValue
    @Nonnull
    public SELF as(String alias) {
        this.collection.setAlias(alias);
        return this.self();
    }

    @CheckReturnValue
    public String toString() {
        return this.collection.getAlias().getOrElse(this.collection::toString);
    }

    @CheckReturnValue
    @Nonnull
    private Driver driver() {
        return this.collection.driver();
    }

    @FunctionalInterface
    public static interface SelenideElementIterable<T extends SelenideElement>
    extends Iterable<T> {
        default public Stream<T> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }
    }
}

