/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.conditions.And;
import com.codeborne.selenide.conditions.Animated;
import com.codeborne.selenide.conditions.Attribute;
import com.codeborne.selenide.conditions.AttributeWithValue;
import com.codeborne.selenide.conditions.CaseSensitiveText;
import com.codeborne.selenide.conditions.Checked;
import com.codeborne.selenide.conditions.ConditionHelpers;
import com.codeborne.selenide.conditions.CssClass;
import com.codeborne.selenide.conditions.CssValue;
import com.codeborne.selenide.conditions.CustomMatch;
import com.codeborne.selenide.conditions.Disabled;
import com.codeborne.selenide.conditions.Editable;
import com.codeborne.selenide.conditions.Enabled;
import com.codeborne.selenide.conditions.ExactOwnText;
import com.codeborne.selenide.conditions.ExactOwnTextCaseSensitive;
import com.codeborne.selenide.conditions.ExactText;
import com.codeborne.selenide.conditions.ExactTextCaseSensitive;
import com.codeborne.selenide.conditions.Exist;
import com.codeborne.selenide.conditions.Focused;
import com.codeborne.selenide.conditions.Hidden;
import com.codeborne.selenide.conditions.Href;
import com.codeborne.selenide.conditions.InnerText;
import com.codeborne.selenide.conditions.Interactable;
import com.codeborne.selenide.conditions.IsImageLoaded;
import com.codeborne.selenide.conditions.MatchAttributeWithValue;
import com.codeborne.selenide.conditions.MatchText;
import com.codeborne.selenide.conditions.NamedCondition;
import com.codeborne.selenide.conditions.OneOfExactTexts;
import com.codeborne.selenide.conditions.OneOfExactTextsCaseSensitive;
import com.codeborne.selenide.conditions.OneOfTexts;
import com.codeborne.selenide.conditions.OneOfTextsCaseSensitive;
import com.codeborne.selenide.conditions.Or;
import com.codeborne.selenide.conditions.OwnText;
import com.codeborne.selenide.conditions.OwnTextCaseSensitive;
import com.codeborne.selenide.conditions.PartialText;
import com.codeborne.selenide.conditions.PartialTextCaseSensitive;
import com.codeborne.selenide.conditions.PartialValue;
import com.codeborne.selenide.conditions.PseudoElementPropertyWithValue;
import com.codeborne.selenide.conditions.Readonly;
import com.codeborne.selenide.conditions.Selected;
import com.codeborne.selenide.conditions.SelectedText;
import com.codeborne.selenide.conditions.TagName;
import com.codeborne.selenide.conditions.Text;
import com.codeborne.selenide.conditions.Value;
import com.codeborne.selenide.conditions.Visible;
import java.util.Arrays;
import java.util.function.Predicate;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public final class Condition {
    public static final WebElementCondition visible = new Visible();
    public static final WebElementCondition exist = new Exist();
    public static final WebElementCondition hidden = new Hidden();
    public static final WebElementCondition appear = Condition.be(visible);
    public static final WebElementCondition disappear = Condition.be(hidden);
    public static final WebElementCondition interactable = new Interactable();
    public static final WebElementCondition readonly = new Readonly();
    public static final WebElementCondition editable = new Editable();
    public static final WebElementCondition animated = new Animated();
    public static final WebElementCondition empty = Condition.and("empty", Condition.exactValue(""), Condition.exactText(""), new WebElementCondition[0]);
    public static final WebElementCondition image = new IsImageLoaded();
    public static final WebElementCondition focused = new Focused();
    public static final WebElementCondition enabled = new Enabled();
    public static final WebElementCondition disabled = new Disabled();
    public static final WebElementCondition selected = new Selected();
    public static final WebElementCondition checked = new Checked();
    public static final WebElementCondition clickable = Condition.and("clickable", interactable, enabled, new WebElementCondition[0]);

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition attribute(String attributeName) {
        return new Attribute(attributeName);
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition attribute(String attributeName, String expectedAttributeValue) {
        return new AttributeWithValue(attributeName, expectedAttributeValue);
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition attributeMatching(String attributeName, String attributeRegex) {
        return new MatchAttributeWithValue(attributeName, attributeRegex);
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition href(String href) {
        return new Href(href);
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition value(String expectedValue) {
        return new Value(expectedValue);
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition partialValue(String expectedValue) {
        return new PartialValue(expectedValue);
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition pseudo(String pseudoElementName, String propertyName, String expectedValue) {
        return new PseudoElementPropertyWithValue(pseudoElementName, propertyName, expectedValue);
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition pseudo(String pseudoElementName, String expectedValue) {
        return new PseudoElementPropertyWithValue(pseudoElementName, "content", expectedValue);
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition exactValue(String value) {
        return Condition.attribute("value", value);
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition name(String name) {
        return Condition.attribute("name", name);
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition type(String type) {
        return Condition.attribute("type", type);
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition id(String id) {
        return Condition.attribute("id", id);
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition matchText(String regex) {
        return new MatchText(regex);
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition oneOfTexts(String ... texts) {
        return new OneOfTexts(Arrays.asList(texts));
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition oneOfTextsCaseSensitive(String ... texts) {
        return new OneOfTextsCaseSensitive(Arrays.asList(texts));
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition oneOfExactTexts(String ... texts) {
        return new OneOfExactTexts(Arrays.asList(texts));
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition oneOfExactTextsCaseSensitive(String ... texts) {
        return new OneOfExactTextsCaseSensitive(Arrays.asList(texts));
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition partialText(String expectedText) {
        return new PartialText(expectedText);
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition partialTextCaseSensitive(String expectedText) {
        return new PartialTextCaseSensitive(expectedText);
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition text(String text) {
        return new Text(text);
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition selectedText(String expectedText) {
        return new SelectedText(expectedText);
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition textCaseSensitive(String text) {
        return new CaseSensitiveText(text);
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition exactText(String text) {
        return new ExactText(text);
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition innerText(String text) {
        return new InnerText(text);
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition ownText(String text) {
        return new OwnText(text);
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition ownTextCaseSensitive(String text) {
        return new OwnTextCaseSensitive(text);
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition exactOwnText(String text) {
        return new ExactOwnText(text);
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition exactOwnTextCaseSensitive(String text) {
        return new ExactOwnTextCaseSensitive(text);
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition exactTextCaseSensitive(String text) {
        return new ExactTextCaseSensitive(text);
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition tagName(String cssClass) {
        return new TagName(cssClass);
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition cssClass(String cssClass) {
        return new CssClass(cssClass);
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition cssValue(String propertyName, @Nullable String expectedValue) {
        return new CssValue(propertyName, expectedValue);
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition match(String description, Predicate<WebElement> predicate) {
        return new CustomMatch(description, predicate);
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition not(WebElementCondition condition) {
        return condition.negate();
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition and(String name, WebElementCondition condition1, WebElementCondition condition2, WebElementCondition ... conditions) {
        return new And(name, ConditionHelpers.merge(condition1, condition2, conditions));
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition allOf(String name, WebElementCondition condition1, WebElementCondition condition2, WebElementCondition ... conditions) {
        return Condition.and(name, condition1, condition2, conditions);
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition allOf(WebElementCondition condition1, WebElementCondition condition2, WebElementCondition ... conditions) {
        return Condition.and("all of", condition1, condition2, conditions);
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition or(String name, WebElementCondition condition1, WebElementCondition condition2, WebElementCondition ... conditions) {
        return new Or(name, ConditionHelpers.merge(condition1, condition2, conditions));
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition anyOf(String name, WebElementCondition condition1, WebElementCondition condition2, WebElementCondition ... conditions) {
        return Condition.or(name, condition1, condition2, conditions);
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition anyOf(WebElementCondition condition1, WebElementCondition condition2, WebElementCondition ... conditions) {
        return Condition.or("any of", condition1, condition2, conditions);
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition be(WebElementCondition delegate) {
        return Condition.wrap("be", delegate);
    }

    @CheckReturnValue
    @Nonnull
    public static WebElementCondition have(WebElementCondition delegate) {
        return Condition.wrap("have", delegate);
    }

    private static WebElementCondition wrap(String prefix, WebElementCondition delegate) {
        return new NamedCondition(prefix, delegate);
    }
}

