/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.CheckResult;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface ObjectCondition<T> {
    @Nonnull
    @CheckReturnValue
    public String description();

    @Nonnull
    @CheckReturnValue
    public String negativeDescription();

    @CheckReturnValue
    public CheckResult check(T var1);

    @Nullable
    @CheckReturnValue
    public String expectedValue();

    @Nonnull
    @CheckReturnValue
    public String describe(T var1);

    default public String message(T object) {
        return this.describe(object) + " " + this.description();
    }

    default public CheckResult result(T object, boolean met, @Nullable Object actualValue) {
        return met ? CheckResult.accepted(actualValue) : CheckResult.rejected(this.message(object), actualValue);
    }
}

