/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ex.UIAssertionError;
import com.codeborne.selenide.impl.CollectionSource;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openqa.selenium.WebElement;

public abstract class WebElementsCondition {
    protected String explanation;

    @Nonnull
    @CheckReturnValue
    public CheckResult check(Driver driver, List<WebElement> elements) {
        throw new UnsupportedOperationException("Implement one of 'check' methods in your condition");
    }

    @Nonnull
    @CheckReturnValue
    public CheckResult check(CollectionSource collection) {
        List<WebElement> elements = collection.getElements();
        return this.check(collection.driver(), elements);
    }

    public void fail(CollectionSource collection, CheckResult lastCheckResult, @Nullable Exception cause, long timeoutMs) {
        throw new UIAssertionError(collection.driver(), this.errorMessage() + System.lineSeparator() + "Actual: " + lastCheckResult.getActualValue() + System.lineSeparator() + "Expected: " + this.expectedValue() + (String)(this.explanation == null ? "" : System.lineSeparator() + "Because: " + this.explanation) + System.lineSeparator() + "Collection: " + collection.description(), this.toString(), lastCheckResult.getActualValue());
    }

    public String errorMessage() {
        return "Collection check failed";
    }

    public String expectedValue() {
        return this.toString();
    }

    public abstract String toString();

    public WebElementsCondition because(String explanation) {
        this.explanation = explanation;
        return this;
    }

    public boolean missingElementsSatisfyCondition() {
        return false;
    }
}

