/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.Command;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.DownloadOptions;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.files.FileFilter;
import com.codeborne.selenide.files.FileFilters;
import com.codeborne.selenide.impl.DownloadFileToFolder;
import com.codeborne.selenide.impl.DownloadFileWithCdp;
import com.codeborne.selenide.impl.DownloadFileWithHttpRequest;
import com.codeborne.selenide.impl.DownloadFileWithProxyServer;
import com.codeborne.selenide.impl.Plugins;
import com.codeborne.selenide.impl.WebElementSource;
import java.io.File;
import java.time.Duration;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class DownloadFile
implements Command<File> {
    private static final Logger log = LoggerFactory.getLogger(DownloadFile.class);
    private final DownloadFileWithHttpRequest downloadFileWithHttpRequest;
    private final DownloadFileWithProxyServer downloadFileWithProxyServer;
    private final DownloadFileToFolder downloadFileToFolder;
    private final DownloadFileWithCdp downloadFileWithCdp;

    public DownloadFile() {
        this(new DownloadFileWithHttpRequest(), new DownloadFileWithProxyServer(), Plugins.inject(DownloadFileToFolder.class), Plugins.inject(DownloadFileWithCdp.class));
    }

    DownloadFile(DownloadFileWithHttpRequest httpGet, DownloadFileWithProxyServer proxy, DownloadFileToFolder folder, DownloadFileWithCdp cdp) {
        this.downloadFileWithHttpRequest = httpGet;
        this.downloadFileWithProxyServer = proxy;
        this.downloadFileToFolder = folder;
        this.downloadFileWithCdp = cdp;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public File execute(SelenideElement selenideElement, WebElementSource linkWithHref, @Nullable Object[] args) {
        WebElement link = linkWithHref.findAndAssertElementIsInteractable();
        Config config = linkWithHref.driver().config();
        DownloadOptions options = this.getDownloadOptions(config, args);
        long timeout = Optional.ofNullable(options.timeout()).map(Duration::toMillis).orElse(config.timeout());
        long incrementTimeout = Optional.ofNullable(options.incrementTimeout()).map(Duration::toMillis).orElse(timeout);
        log.debug("Download file: {}", (Object)options);
        switch (options.getMethod()) {
            case HTTPGET: {
                return this.downloadFileWithHttpRequest.download(linkWithHref.driver(), link, timeout, options.getFilter());
            }
            case PROXY: {
                return this.downloadFileWithProxyServer.download(linkWithHref, link, timeout, options.getFilter(), options.getAction());
            }
            case FOLDER: {
                return this.downloadFileToFolder.download(linkWithHref, link, timeout, incrementTimeout, options.getFilter(), options.getAction());
            }
            case CDP: {
                return this.downloadFileWithCdp.download(linkWithHref, link, timeout, incrementTimeout, options.getFilter(), options.getAction());
            }
        }
        throw new IllegalArgumentException("Unknown file download mode: " + options.getMethod());
    }

    @CheckReturnValue
    @Nonnull
    private DownloadOptions getDownloadOptions(Config config, @Nullable Object[] args) {
        Object object;
        if (args != null && args.length > 0 && (object = args[0]) instanceof DownloadOptions) {
            DownloadOptions downloadOptions = (DownloadOptions)object;
            return downloadOptions;
        }
        return DownloadOptions.using(config.fileDownload()).withFilter(this.getFileFilter(args)).withTimeout(this.getTimeout(config, args));
    }

    @CheckReturnValue
    long getTimeout(Config config, @Nullable Object[] args) {
        Object object;
        if (args != null && args.length > 0 && (object = args[0]) instanceof Long) {
            Long timeoutArgument = (Long)object;
            return timeoutArgument;
        }
        return config.timeout();
    }

    @CheckReturnValue
    @Nonnull
    FileFilter getFileFilter(@Nullable Object[] args) {
        Object object;
        if (args != null && args.length > 0 && (object = args[0]) instanceof FileFilter) {
            FileFilter fileFilter = (FileFilter)object;
            return fileFilter;
        }
        if (args != null && args.length > 1 && (object = args[1]) instanceof FileFilter) {
            FileFilter fileFilter = (FileFilter)object;
            return fileFilter;
        }
        return FileFilters.none();
    }
}

