/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.Command;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.DragAndDropOptions;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.impl.JavaScript;
import com.codeborne.selenide.impl.WebElementSource;
import java.util.Arrays;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class DragAndDrop
implements Command<SelenideElement> {
    private static final JavaScript js = new JavaScript("drag_and_drop_script.js");

    @Override
    @Nonnull
    public SelenideElement execute(SelenideElement proxy, WebElementSource locator, @Nullable Object[] args) {
        DragAndDropOptions options = this.dragAndDropOptions(args, DragAndDropOptions.DragAndDropMethod.JS);
        DragAndDropOptions.DragAndDropMethod method = options.getMethod();
        SelenideElement target = options.getTarget(locator.driver());
        target.shouldBe(Condition.visible);
        this.dragAndDrop(locator, target, method);
        return proxy;
    }

    @CheckReturnValue
    @Nonnull
    protected DragAndDropOptions dragAndDropOptions(@Nullable Object[] args, DragAndDropOptions.DragAndDropMethod defaultMethod) {
        Object object;
        if (args == null || args.length == 0) {
            throw new IllegalArgumentException("Missing Drag'n'Drop arguments");
        }
        Object object2 = args[0];
        if (object2 instanceof DragAndDropOptions) {
            DragAndDropOptions options = (DragAndDropOptions)object2;
            return options;
        }
        DragAndDropOptions.DragAndDropMethod method = defaultMethod;
        if (args.length > 1 && (object = args[1]) instanceof DragAndDropOptions) {
            DragAndDropOptions dragAndDropOptions = (DragAndDropOptions)object;
            method = dragAndDropOptions.getMethod();
        }
        return new DragAndDropOptions(this.findTarget(args), method);
    }

    @Nonnull
    @CheckReturnValue
    private DragAndDropOptions.DragAndDropTarget findTarget(Object[] args) {
        Object object = args[0];
        if (object instanceof String) {
            String cssSelector = (String)object;
            return new DragAndDropOptions.DragAndDropTarget.CssSelector(cssSelector);
        }
        object = args[0];
        if (object instanceof WebElement) {
            WebElement webElement = (WebElement)object;
            return new DragAndDropOptions.DragAndDropTarget.Element(webElement);
        }
        throw new IllegalArgumentException("Cannot detect Drag'n'Drop target from arguments: " + Arrays.toString(args));
    }

    private void dragAndDrop(WebElementSource locator, SelenideElement target, DragAndDropOptions.DragAndDropMethod method) {
        switch (method) {
            case JS: {
                this.dragAndDropUsingJavaScript(locator.driver(), locator.getWebElement(), target.getWrappedElement());
                break;
            }
            case ACTIONS: {
                this.dragAndDropUsingActions(locator.driver(), locator.getWebElement(), target.getWrappedElement());
                break;
            }
            default: {
                throw new IllegalArgumentException("Drag and Drop method not defined!");
            }
        }
    }

    private void dragAndDropUsingActions(Driver driver, WebElement from, WebElement target) {
        driver.actions().dragAndDrop(from, target).perform();
    }

    private void dragAndDropUsingJavaScript(Driver driver, WebElement from, WebElement to) {
        js.execute(driver, from, to);
    }
}

