/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions.datetime;

import com.codeborne.selenide.conditions.datetime.DateTimeFormatCondition;
import com.codeborne.selenide.conditions.datetime.TemporalCondition;
import java.time.LocalDateTime;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
class DateTimeEquals
extends TemporalCondition<LocalDateTime> {
    private final LocalDateTime expectedDateTime;

    DateTimeEquals(LocalDateTime expectedDateTime, String pattern) {
        this(expectedDateTime, new DateTimeFormatCondition(pattern));
    }

    DateTimeEquals(LocalDateTime expectedDateTime, DateTimeFormatCondition format) {
        super("datetime value", format);
        this.expectedDateTime = expectedDateTime;
    }

    @Override
    protected boolean matches(LocalDateTime actualDateTime) {
        return this.expectedDateTime.isEqual(actualDateTime);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String toString() {
        return String.format("%s \"%s\"", this.getName(), this.format(this.expectedDateTime));
    }
}

