/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions.webdriver;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.ObjectCondition;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.WebDriver;

@ParametersAreNonnullByDefault
public class CookieWithName
implements ObjectCondition<WebDriver> {
    private final String expectedName;

    public CookieWithName(String expectedName) {
        this.expectedName = expectedName;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String description() {
        return String.format("should have a cookie with name \"%s\"", this.expectedName);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String negativeDescription() {
        return String.format("should not have cookie with name \"%s\"", this.expectedName);
    }

    @Override
    @CheckReturnValue
    public CheckResult check(WebDriver webDriver) {
        Cookie cookie = webDriver.manage().getCookieNamed(this.expectedName);
        return this.result(webDriver, cookie != null, this.actualValue(webDriver));
    }

    @Nonnull
    @CheckReturnValue
    private String actualValue(WebDriver webDriver) {
        return String.format("Available cookies: %s", webDriver.manage().getCookies());
    }

    @Override
    @Nullable
    @CheckReturnValue
    public String expectedValue() {
        return String.format("cookie with name \"%s\"", this.expectedName);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String describe(@Nonnull WebDriver webDriver) {
        return "webdriver";
    }
}

