/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.Alias;
import com.codeborne.selenide.impl.CollectionSource;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class CollectionSnapshot
implements CollectionSource {
    private final CollectionSource originalCollection;
    private final List<WebElement> elementsSnapshot;
    private Alias alias = Alias.NONE;

    public CollectionSnapshot(CollectionSource collection) {
        this.originalCollection = collection;
        this.elementsSnapshot = new ArrayList<WebElement>(collection.getElements());
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public List<WebElement> getElements() {
        return this.elementsSnapshot;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public WebElement getElement(int index) {
        return this.elementsSnapshot.get(index);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String getSearchCriteria() {
        return String.format("%s.snapshot(%d elements)", this.originalCollection.description(), this.elementsSnapshot.size());
    }

    public String toString() {
        return this.getSearchCriteria();
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public Driver driver() {
        return this.originalCollection.driver();
    }

    @Override
    @Nonnull
    public Alias getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(String alias) {
        this.alias = new Alias(alias);
    }
}

