/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ex.FileNotDownloadedError;
import com.codeborne.selenide.files.DownloadedFile;
import com.codeborne.selenide.files.FileFilter;
import com.codeborne.selenide.impl.Downloader;
import com.codeborne.selenide.impl.ElementDescriber;
import com.codeborne.selenide.impl.HttpHelper;
import com.codeborne.selenide.impl.Plugins;
import com.codeborne.selenide.impl.WebdriverCookieStore;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntityContainer;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.protocol.BasicHttpContext;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class DownloadFileWithHttpRequest {
    private static final Logger log = LoggerFactory.getLogger(DownloadFileWithHttpRequest.class);
    private final ElementDescriber describe = Plugins.inject(ElementDescriber.class);
    protected boolean ignoreSelfSignedCerts = true;
    private final Downloader downloader;
    private final HttpHelper httpHelper = new HttpHelper();

    public DownloadFileWithHttpRequest() {
        this(new Downloader());
    }

    DownloadFileWithHttpRequest(Downloader downloader) {
        this.downloader = downloader;
    }

    @CheckReturnValue
    @Nonnull
    public File download(Driver driver, WebElement element, long timeout, FileFilter fileFilter) {
        String fileToDownloadLocation = element.getAttribute("href");
        if (fileToDownloadLocation == null || fileToDownloadLocation.trim().isEmpty()) {
            String link = "https://selenide.org/javadoc/current/com/codeborne/selenide/FileDownloadMode.html";
            throw new IllegalArgumentException("The element does not have \"href\" attribute: %s, so method HTTPGET cannot download the file.%nPlease try another download method: FOLDER, CDP or PROXY.%nRead more about possible download methods: %s".formatted(this.describe.fully(driver, element), link).trim());
        }
        return this.download(driver, fileToDownloadLocation, timeout, fileFilter);
    }

    @CheckReturnValue
    @Nonnull
    public File download(Driver driver, URI url, long timeout, FileFilter fileFilter) {
        return this.download(driver, url.toASCIIString(), timeout, fileFilter);
    }

    @CheckReturnValue
    @Nonnull
    public File download(Driver driver, String relativeOrAbsoluteUrl, long timeout, FileFilter fileFilter) {
        File file;
        block8: {
            String url = this.makeAbsoluteUrl(driver.config(), relativeOrAbsoluteUrl);
            CloseableHttpClient httpClient = this.ignoreSelfSignedCerts ? this.createTrustingHttpClient() : this.createDefaultHttpClient();
            try {
                Resource resource = DownloadFileWithHttpRequest.parseUrl(url);
                HttpGet httpGet = new HttpGet(resource.uri());
                this.configureHttpGet(httpGet, timeout);
                this.addHttpHeaders(driver, httpGet, resource.credentials());
                file = (File)httpClient.execute((ClassicHttpRequest)httpGet, this.createHttpContext(driver), response -> this.handleResponse(driver, timeout, fileFilter, url, response));
                if (httpClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (httpClient != null) {
                        try {
                            httpClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new FileNotDownloadedError(driver, "Failed to download " + url + " in " + timeout + " ms.", timeout, e);
                }
            }
            httpClient.close();
        }
        return file;
    }

    @Nonnull
    private File handleResponse(Driver driver, long timeout, FileFilter fileFilter, String url, ClassicHttpResponse response) throws IOException {
        if (response.getCode() >= 500) {
            throw new RuntimeException("Failed to download file " + url + ": " + response);
        }
        if (response.getCode() >= 400) {
            throw new FileNotDownloadedError(driver, "Failed to download file " + url + ": " + response, timeout);
        }
        String fileName = this.getFileName(url, (HttpResponse)response);
        File downloadedFile = this.downloader.prepareTargetFile(driver.config(), fileName);
        this.saveContentToFile((HttpEntityContainer)response, downloadedFile);
        if (!fileFilter.match(new DownloadedFile(downloadedFile, Collections.emptyMap()))) {
            String message = String.format("Failed to download file from %s in %d ms.%s;%n actually downloaded: %s", url, timeout, fileFilter.description(), downloadedFile.getAbsolutePath());
            throw new FileNotDownloadedError(driver, message, timeout);
        }
        return downloadedFile;
    }

    @CheckReturnValue
    @Nonnull
    String makeAbsoluteUrl(Config config, String relativeOrAbsoluteUrl) {
        return relativeOrAbsoluteUrl.startsWith("/") ? config.baseUrl() + relativeOrAbsoluteUrl : relativeOrAbsoluteUrl;
    }

    static Resource parseUrl(String urlWithCredentials) throws IOException {
        try {
            URI uri = new URI(urlWithCredentials);
            return uri.getUserInfo() == null ? new Resource(uri, "") : new Resource(new URI(urlWithCredentials.replace(uri.getRawUserInfo() + "@", "")), uri.getUserInfo());
        }
        catch (URISyntaxException invalidUrl) {
            throw new IOException(String.format("Failed to download file from %s", urlWithCredentials), invalidUrl);
        }
    }

    protected void configureHttpGet(HttpGet httpGet, long timeout) {
        httpGet.setConfig(RequestConfig.custom().setConnectTimeout(timeout, TimeUnit.MILLISECONDS).setConnectionRequestTimeout(timeout, TimeUnit.MILLISECONDS).setResponseTimeout(timeout, TimeUnit.MILLISECONDS).setRedirectsEnabled(true).setCircularRedirectsAllowed(true).setMaxRedirects(20).build());
    }

    @CheckReturnValue
    @Nonnull
    protected CloseableHttpClient createDefaultHttpClient() {
        return HttpClients.createDefault();
    }

    @CheckReturnValue
    @Nonnull
    protected CloseableHttpClient createTrustingHttpClient() throws IOException {
        try {
            HttpClientBuilder builder = HttpClientBuilder.create();
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)new TrustAllStrategy()).build();
            NoopHostnameVerifier hostnameVerifier = NoopHostnameVerifier.INSTANCE;
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build();
            PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            builder.setConnectionManager((HttpClientConnectionManager)connMgr);
            return builder.build();
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    @CheckReturnValue
    @Nonnull
    protected HttpContext createHttpContext(Driver driver) {
        BasicHttpContext localContext = new BasicHttpContext();
        if (driver.hasWebDriverStarted()) {
            localContext.setAttribute("http.cookie-store", (Object)new WebdriverCookieStore(driver.getWebDriver()));
        }
        return localContext;
    }

    protected void addHttpHeaders(Driver driver, HttpGet httpGet, String credentials) {
        if (driver.hasWebDriverStarted()) {
            httpGet.setHeader("User-Agent", (Object)driver.getUserAgent());
        }
        if (!credentials.isEmpty()) {
            httpGet.setHeader("Authorization", (Object)("Basic " + Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8))));
        }
    }

    @CheckReturnValue
    @Nonnull
    protected String getFileName(String fileToDownloadLocation, HttpResponse response) {
        for (Header header : response.getHeaders()) {
            Optional<String> fileName = this.httpHelper.getFileNameFromContentDisposition(header.getName(), header.getValue());
            if (!fileName.isPresent()) continue;
            return this.httpHelper.normalize(fileName.get());
        }
        log.info("Cannot extract file name for {}. Found headers: {}", (Object)fileToDownloadLocation, (Object)this.headersToString(response));
        String fileNameFromUrl = this.httpHelper.getFileName(fileToDownloadLocation);
        String result = StringUtils.isNotBlank((CharSequence)fileNameFromUrl) ? fileNameFromUrl : this.downloader.randomFileName();
        log.info("Generated file name for {}: {}", (Object)fileToDownloadLocation, (Object)result);
        return result;
    }

    @Nonnull
    private String headersToString(HttpResponse response) {
        return Stream.of(response.getHeaders()).map(h -> h.getName() + "=" + h.getValue()).collect(Collectors.joining(", "));
    }

    protected void saveContentToFile(HttpEntityContainer response, File downloadedFile) throws IOException {
        FileUtils.copyInputStreamToFile((InputStream)response.getEntity().getContent(), (File)downloadedFile);
    }

    @ParametersAreNonnullByDefault
    record Resource(URI uri, String credentials) {
    }

    @ParametersAreNonnullByDefault
    private static class TrustAllStrategy
    implements TrustStrategy {
        private TrustAllStrategy() {
        }

        public boolean isTrusted(X509Certificate[] arg0, String arg1) {
            return true;
        }
    }
}

