/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.proxy;

import com.codeborne.selenide.proxy.RequestMatcher;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@Nonnull
@CheckReturnValue
@ParametersAreNonnullByDefault
public class RequestMatchers {
    public static RequestMatcher urlEquals(RequestMatcher.HttpMethod method, String url) {
        return RequestMatchers.urlMatcher(method, requestUrl -> requestUrl.equals(url));
    }

    public static RequestMatcher urlStartsWith(RequestMatcher.HttpMethod method, String url) {
        return RequestMatchers.urlMatcher(method, requestUrl -> requestUrl.startsWith(url));
    }

    public static RequestMatcher urlEndsWith(RequestMatcher.HttpMethod method, String url) {
        return RequestMatchers.urlMatcher(method, requestUrl -> requestUrl.endsWith(url));
    }

    public static RequestMatcher urlContains(RequestMatcher.HttpMethod method, String url) {
        return RequestMatchers.urlMatcher(method, requestUrl -> requestUrl.contains(url));
    }

    public static RequestMatcher urlMatches(RequestMatcher.HttpMethod method, String urlRegex) {
        return RequestMatchers.urlMatches(method, Pattern.compile(urlRegex));
    }

    public static RequestMatcher urlMatches(RequestMatcher.HttpMethod method, Pattern urlRegex) {
        return RequestMatchers.urlMatcher(method, requestUrl -> urlRegex.matcher((CharSequence)requestUrl).matches());
    }

    public static RequestMatcher urlMatcher(RequestMatcher.HttpMethod method, Function<String, Boolean> urlMatches) {
        return (request, contents, messageInfo) -> RequestMatcher.methodMatches(request, method) && (Boolean)urlMatches.apply(messageInfo.getUrl()) != false;
    }
}

