/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.selector;

import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.JavaScript;
import java.io.Serializable;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class ByDeepShadow {
    private static final JavaScript jsSource = new JavaScript("query-selector-shadow-dom.js");

    @CheckReturnValue
    @Nonnull
    public static By cssSelector(String target) {
        return new ByDeepShadowCss(target);
    }

    @ParametersAreNonnullByDefault
    public static class ByDeepShadowCss
    extends By
    implements Serializable {
        private final String target;

        ByDeepShadowCss(String target) {
            this.target = target;
        }

        @CheckReturnValue
        @Nonnull
        public WebElement findElement(SearchContext context) {
            List<WebElement> found = this.findElements(context);
            if (found.isEmpty()) {
                throw new NoSuchElementException("Cannot locate an element in shadow dom " + this);
            }
            return found.get(0);
        }

        @CheckReturnValue
        @Nonnull
        public List<WebElement> findElements(SearchContext context) {
            try {
                return (List)jsSource.execute(context, this.target);
            }
            catch (JavascriptException e) {
                throw new NoSuchElementException(Cleanup.of.webdriverExceptionMessage(e));
            }
        }

        @CheckReturnValue
        @Nonnull
        public String toString() {
            return "By.shadowDeepCss: " + this.target;
        }
    }
}

