/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.selector;

import com.codeborne.selenide.impl.JavaScript;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class FocusedElementLocator
extends By {
    private static final JavaScript js = new JavaScript("get-focused-element.js");

    @Nonnull
    @CheckReturnValue
    public WebElement findElement(SearchContext context) {
        WebElement element = (WebElement)js.execute(context, js.node(context));
        if (element == null) {
            throw new NoSuchElementException("Cannot find a focused element");
        }
        return element;
    }

    @Nonnull
    @CheckReturnValue
    public List<WebElement> findElements(SearchContext context) {
        return Arrays.asList(this.findElement(context));
    }
}

