/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import java.util.regex.Pattern;
import org.openqa.selenium.WebElement;

public class MatchAttributeWithValue
extends Condition {
    private final String attributeName;
    private final Pattern attributeRegex;

    public MatchAttributeWithValue(String attributeName, String attributeRegex) {
        super("match attribute");
        this.attributeName = attributeName;
        this.attributeRegex = Pattern.compile(attributeRegex);
    }

    @Override
    public boolean apply(Driver driver, WebElement element) {
        return this.attributeRegex.matcher(this.getAttributeValue(element)).matches();
    }

    @Override
    public String actualValue(Driver driver, WebElement element) {
        return String.format("%s=\"%s\"", this.attributeName, this.getAttributeValue(element));
    }

    @Override
    public String toString() {
        return String.format("%s %s=\"%s\"", this.getName(), this.attributeName, this.attributeRegex);
    }

    private String getAttributeValue(WebElement element) {
        String attr = element.getAttribute(this.attributeName);
        return attr == null ? "" : attr;
    }
}

