/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.WebElementsCollection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.openqa.selenium.WebElement;

public class FilteringCollection
implements WebElementsCollection {
    private final WebElementsCollection originalCollection;
    private final Predicate<WebElement> filter;

    public FilteringCollection(WebElementsCollection originalCollection, Predicate<WebElement> filter) {
        this.originalCollection = originalCollection;
        this.filter = filter;
    }

    public FilteringCollection(WebElementsCollection originalCollection, Condition filter) {
        this.originalCollection = originalCollection;
        this.filter = new ConditionPredicate(this.driver(), filter);
    }

    @Override
    public List<WebElement> getElements() {
        return this.originalCollection.getElements().stream().filter(this.filter).collect(Collectors.toList());
    }

    @Override
    public String description() {
        return this.originalCollection.description() + ".filter(" + this.filter + ')';
    }

    @Override
    public Driver driver() {
        return this.originalCollection.driver();
    }

    private static class ConditionPredicate
    implements Predicate<WebElement> {
        private final Driver driver;
        private final Condition filter;

        private ConditionPredicate(Driver driver, Condition filter) {
            this.driver = driver;
            this.filter = filter;
        }

        @Override
        public boolean test(@Nullable WebElement webElement) {
            return this.filter.apply(this.driver, webElement);
        }

        public String toString() {
            return this.filter.toString();
        }
    }
}

