/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Driver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;

public class WebDriverLogs {
    private final Driver driver;

    WebDriverLogs(Driver driver) {
        this.driver = driver;
    }

    public List<String> logs(String logType) {
        return this.logs(logType, Level.ALL);
    }

    public List<String> logs(String logType, Level logLevel) {
        return this.listToString(this.getLogEntries(logType, logLevel));
    }

    private List<LogEntry> getLogEntries(String logType, Level logLevel) {
        try {
            return this.filter(this.driver.getWebDriver().manage().logs().get(logType), logLevel);
        }
        catch (UnsupportedOperationException ignore) {
            return Collections.emptyList();
        }
    }

    private List<LogEntry> filter(LogEntries entries, Level level) {
        return Collections.unmodifiableList(entries.getAll().stream().filter(entry -> entry.getLevel().intValue() >= level.intValue()).collect(Collectors.toList()));
    }

    private <T> List<String> listToString(List<T> objects) {
        if (objects == null || objects.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(objects.size());
        for (T object : objects) {
            result.add(object.toString());
        }
        return result;
    }
}

