/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.Command;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.commands.Append;
import com.codeborne.selenide.commands.Click;
import com.codeborne.selenide.commands.ContextClick;
import com.codeborne.selenide.commands.DoubleClick;
import com.codeborne.selenide.commands.DownloadFile;
import com.codeborne.selenide.commands.DragAndDropTo;
import com.codeborne.selenide.commands.Execute;
import com.codeborne.selenide.commands.Exists;
import com.codeborne.selenide.commands.Find;
import com.codeborne.selenide.commands.FindAll;
import com.codeborne.selenide.commands.FindAllByXpath;
import com.codeborne.selenide.commands.FindByXpath;
import com.codeborne.selenide.commands.GetAttribute;
import com.codeborne.selenide.commands.GetClosest;
import com.codeborne.selenide.commands.GetCssValue;
import com.codeborne.selenide.commands.GetDataAttribute;
import com.codeborne.selenide.commands.GetInnerHtml;
import com.codeborne.selenide.commands.GetInnerText;
import com.codeborne.selenide.commands.GetLastChild;
import com.codeborne.selenide.commands.GetName;
import com.codeborne.selenide.commands.GetParent;
import com.codeborne.selenide.commands.GetPreceding;
import com.codeborne.selenide.commands.GetPseudoValue;
import com.codeborne.selenide.commands.GetSearchCriteria;
import com.codeborne.selenide.commands.GetSelectedOption;
import com.codeborne.selenide.commands.GetSelectedOptions;
import com.codeborne.selenide.commands.GetSelectedText;
import com.codeborne.selenide.commands.GetSelectedValue;
import com.codeborne.selenide.commands.GetSibling;
import com.codeborne.selenide.commands.GetText;
import com.codeborne.selenide.commands.GetValue;
import com.codeborne.selenide.commands.GetWrappedElement;
import com.codeborne.selenide.commands.Hover;
import com.codeborne.selenide.commands.IsDisplayed;
import com.codeborne.selenide.commands.IsImage;
import com.codeborne.selenide.commands.Matches;
import com.codeborne.selenide.commands.PressEnter;
import com.codeborne.selenide.commands.PressEscape;
import com.codeborne.selenide.commands.PressTab;
import com.codeborne.selenide.commands.ScrollIntoView;
import com.codeborne.selenide.commands.ScrollTo;
import com.codeborne.selenide.commands.SelectOptionByTextOrIndex;
import com.codeborne.selenide.commands.SelectOptionByValue;
import com.codeborne.selenide.commands.SelectOptionContainingText;
import com.codeborne.selenide.commands.SelectRadio;
import com.codeborne.selenide.commands.SetSelected;
import com.codeborne.selenide.commands.SetValue;
import com.codeborne.selenide.commands.Should;
import com.codeborne.selenide.commands.ShouldBe;
import com.codeborne.selenide.commands.ShouldHave;
import com.codeborne.selenide.commands.ShouldNot;
import com.codeborne.selenide.commands.ShouldNotBe;
import com.codeborne.selenide.commands.ShouldNotHave;
import com.codeborne.selenide.commands.TakeScreenshot;
import com.codeborne.selenide.commands.TakeScreenshotAsImage;
import com.codeborne.selenide.commands.ToString;
import com.codeborne.selenide.commands.ToWebElement;
import com.codeborne.selenide.commands.UploadFile;
import com.codeborne.selenide.commands.UploadFileFromClasspath;
import com.codeborne.selenide.commands.Val;
import com.codeborne.selenide.impl.WebElementSource;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Commands {
    private static Commands collection;
    private final Map<String, Command<?>> commands = new ConcurrentHashMap(128);

    public static synchronized Commands getInstance() {
        if (collection == null) {
            collection = new Commands();
            collection.resetDefaults();
        }
        return collection;
    }

    public final synchronized void resetDefaults() {
        this.commands.clear();
        this.addFindCommands();
        this.addClickCommands();
        this.addModifyCommands();
        this.addInfoCommands();
        this.addSelectCommands();
        this.addKeyboardCommands();
        this.addActionsCommands();
        this.addShouldCommands();
        this.addShouldNotCommands();
        this.addFileCommands();
        this.addTechnicalCommands();
    }

    private void addTechnicalCommands() {
        this.add("toString", new ToString());
        this.add("toWebElement", new ToWebElement());
        this.add("getWrappedElement", new GetWrappedElement());
        this.add("screenshot", new TakeScreenshot());
        this.add("screenshotAsImage", new TakeScreenshotAsImage());
        this.add("getSearchCriteria", new GetSearchCriteria());
        this.add("execute", new Execute());
    }

    private void addActionsCommands() {
        this.add("dragAndDropTo", new DragAndDropTo());
        this.add("hover", new Hover());
        this.add("scrollTo", new ScrollTo());
        this.add("scrollIntoView", new ScrollIntoView());
    }

    private void addInfoCommands() {
        this.add("attr", new GetAttribute());
        this.add("getAttribute", new GetAttribute());
        this.add("getCssValue", new GetCssValue());
        this.add("data", new GetDataAttribute());
        this.add("exists", new Exists());
        this.add("innerText", new GetInnerText());
        this.add("innerHtml", new GetInnerHtml());
        this.add("has", new Matches());
        this.add("is", new Matches());
        this.add("isDisplayed", new IsDisplayed());
        this.add("isImage", new IsImage());
        this.add("getText", new GetText());
        this.add("name", new GetName());
        this.add("text", new GetText());
        this.add("getValue", new GetValue());
        this.add("pseudo", new GetPseudoValue());
    }

    private void addClickCommands() {
        this.add("click", new Click());
        this.add("contextClick", new ContextClick());
        this.add("doubleClick", new DoubleClick());
    }

    private void addModifyCommands() {
        this.add("selectRadio", new SelectRadio());
        this.add("setSelected", new SetSelected());
        this.add("setValue", new SetValue());
        this.add("val", new Val());
        this.add("append", new Append());
    }

    private void addFindCommands() {
        this.add("find", new Find());
        this.add("$", new Find());
        this.add("$x", new FindByXpath());
        this.add("findAll", new FindAll());
        this.add("$$", new FindAll());
        this.add("$$x", new FindAllByXpath());
        this.add("closest", new GetClosest());
        this.add("parent", new GetParent());
        this.add("sibling", new GetSibling());
        this.add("preceding", new GetPreceding());
        this.add("lastChild", new GetLastChild());
    }

    private void addKeyboardCommands() {
        this.add("pressEnter", new PressEnter());
        this.add("pressEscape", new PressEscape());
        this.add("pressTab", new PressTab());
    }

    private void addSelectCommands() {
        this.add("getSelectedOption", new GetSelectedOption());
        this.add("getSelectedOptions", new GetSelectedOptions());
        this.add("getSelectedText", new GetSelectedText());
        this.add("getSelectedValue", new GetSelectedValue());
        this.add("selectOption", new SelectOptionByTextOrIndex());
        this.add("selectOptionContainingText", new SelectOptionContainingText());
        this.add("selectOptionByValue", new SelectOptionByValue());
    }

    private void addFileCommands() {
        this.add("download", new DownloadFile());
        this.add("uploadFile", new UploadFile());
        this.add("uploadFromClasspath", new UploadFileFromClasspath());
    }

    private void addShouldNotCommands() {
        this.add("shouldNot", new ShouldNot());
        this.add("shouldNotHave", new ShouldNotHave());
        this.add("shouldNotBe", new ShouldNotBe());
        this.add("waitWhile", new ShouldNotBe());
    }

    private void addShouldCommands() {
        this.add("should", new Should());
        this.add("shouldHave", new ShouldHave());
        this.add("shouldBe", new ShouldBe());
        this.add("waitUntil", new ShouldBe());
    }

    public void add(String method, Command<?> command) {
        this.commands.put(method, command);
    }

    public <T> T execute(Object proxy, WebElementSource webElementSource, String methodName, Object[] args) throws IOException {
        Command<?> command = this.commands.get(methodName);
        if (command == null) {
            throw new IllegalArgumentException("Unknown Selenide method: " + methodName);
        }
        return (T)command.execute((SelenideElement)proxy, webElementSource, args);
    }
}

