/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class AttributeWithValue
extends Condition {
    private final String attributeName;
    private final String expectedAttributeValue;

    public AttributeWithValue(String attributeName, String expectedAttributeValue) {
        super("attribute");
        this.attributeName = attributeName;
        this.expectedAttributeValue = expectedAttributeValue;
    }

    @Override
    public boolean apply(Driver driver, WebElement element) {
        return this.expectedAttributeValue.equals(this.getAttributeValue(element));
    }

    @Override
    public String actualValue(Driver driver, WebElement element) {
        return String.format("%s=\"%s\"", this.attributeName, this.getAttributeValue(element));
    }

    @Override
    public String toString() {
        return String.format("%s %s=\"%s\"", this.getName(), this.attributeName, this.expectedAttributeValue);
    }

    private String getAttributeValue(WebElement element) {
        String attr = element.getAttribute(this.attributeName);
        return attr == null ? "" : attr;
    }
}

