/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.Cleanup;
import java.util.Arrays;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Events {
    public static Events events = new Events(LoggerFactory.getLogger(Events.class));
    private final Logger log;
    private static final String JS_CODE_TO_TRIGGER_EVENT = "var webElement = arguments[0];\nvar eventNames = arguments[1];\nfor (var i = 0; i < eventNames.length; i++) {  if (document.createEventObject) {\n    var evt = document.createEventObject();\n    webElement.fireEvent('on' + eventNames[i], evt);\n  }\n  else {\n    var evt = document.createEvent('HTMLEvents');\n     evt.initEvent(eventNames[i], true, true );\n     webElement.dispatchEvent(evt);\n  }\n}";

    Events(Logger log) {
        this.log = log;
    }

    public void fireEvent(Driver driver, WebElement element, String ... event) {
        try {
            this.executeJavaScript(driver, element, event);
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
        }
        catch (Exception e) {
            this.log.warn("Failed to trigger events {}: {}", Arrays.asList(event), (Object)Cleanup.of.webdriverExceptionMessage(e));
        }
    }

    void executeJavaScript(Driver driver, WebElement element, String ... event) {
        driver.executeJavaScript(JS_CODE_TO_TRIGGER_EVENT, element, event);
    }
}

