/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.junit;

import com.codeborne.selenide.logevents.ErrorsCollector;
import com.codeborne.selenide.logevents.SelenideLogger;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class SoftAsserts
extends ExternalResource {
    private Description currentTest;

    public Statement apply(Statement base, Description description) {
        this.currentTest = description;
        return super.apply(base, description);
    }

    protected void before() {
        SelenideLogger.addListener("softAssert", new ErrorsCollector());
    }

    protected void after() {
        ErrorsCollector errorsCollector = (ErrorsCollector)SelenideLogger.removeListener("softAssert");
        errorsCollector.failIfErrors(this.currentTest.getDisplayName());
    }
}

