/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.testng;

import com.codeborne.selenide.logevents.SimpleReport;
import com.codeborne.selenide.testng.annotations.Report;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestResult;
import org.testng.internal.ConstructorOrMethod;

public class TextReport
implements IInvokedMethodListener {
    protected SimpleReport report = new SimpleReport();
    public static boolean onFailedTest = true;
    public static boolean onSucceededTest = true;

    public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
        if ((onFailedTest || onSucceededTest) && this.isClassAnnotatedWithReport(method)) {
            this.report.start();
        }
    }

    public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
        if ((testResult.isSuccess() && onSucceededTest || !testResult.isSuccess() && onFailedTest) && this.isClassAnnotatedWithReport(method)) {
            this.report.finish(testResult.getName());
        }
        this.report.clean();
    }

    private boolean isClassAnnotatedWithReport(IInvokedMethod method) {
        ConstructorOrMethod consOrMethod = method.getTestMethod().getConstructorOrMethod();
        Report annotation = consOrMethod.getDeclaringClass().getAnnotation(Report.class);
        return annotation != null;
    }
}

