/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import io.github.bonigarcia.wdm.WebDriverManager;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdgeDriverFactory
extends AbstractDriverFactory {
    private static final Logger log = LoggerFactory.getLogger(EdgeDriverFactory.class);
    private static final int FIRST_VERSION_BASED_ON_CHROMIUM = 75;
    private String browserVersion = null;

    @Override
    public void setupWebdriverBinary() {
        if (this.isSystemPropertyNotSet("webdriver.edge.driver")) {
            WebDriverManager manager = WebDriverManager.edgedriver();
            manager.setup();
            this.browserVersion = manager.getDownloadedVersion();
        }
    }

    @Override
    public WebDriver create(Config config, Browser browser, Proxy proxy) {
        EdgeOptions options = this.createCapabilities(config, browser, proxy);
        return new EdgeDriver(options);
    }

    public EdgeOptions createCapabilities(Config config, Browser browser, Proxy proxy) {
        MutableCapabilities capabilities = this.createCommonCapabilities(config, browser, proxy);
        if (this.browserVersion != null && this.majorVersion(this.browserVersion) >= 75) {
            capabilities.setCapability("acceptInsecureCerts", true);
        }
        EdgeOptions options = new EdgeOptions();
        options.merge((Capabilities)capabilities);
        if (!config.browserBinary().isEmpty()) {
            log.info("Using browser binary: {}", (Object)config.browserBinary());
            log.warn("Changing browser binary not supported in Edge, setting will be ignored.");
        }
        return options;
    }
}

