/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.SelenideDriver;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import com.codeborne.selenide.webdriver.BrowserResizer;
import com.codeborne.selenide.webdriver.ChromeDriverFactory;
import com.codeborne.selenide.webdriver.DefaultDriverFactory;
import com.codeborne.selenide.webdriver.DriverFactory;
import com.codeborne.selenide.webdriver.EdgeDriverFactory;
import com.codeborne.selenide.webdriver.FirefoxDriverFactory;
import com.codeborne.selenide.webdriver.InternetExplorerDriverFactory;
import com.codeborne.selenide.webdriver.LegacyFirefoxDriverFactory;
import com.codeborne.selenide.webdriver.OperaDriverFactory;
import com.codeborne.selenide.webdriver.RemoteDriverFactory;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverFactory {
    private static final Logger log = LoggerFactory.getLogger(WebDriverFactory.class);
    protected Map<String, AbstractDriverFactory> factories = this.factories();
    protected RemoteDriverFactory remoteDriverFactory = new RemoteDriverFactory();
    protected BrowserResizer browserResizer = new BrowserResizer();

    private Map<String, AbstractDriverFactory> factories() {
        HashMap<String, AbstractDriverFactory> result = new HashMap<String, AbstractDriverFactory>();
        result.put("chrome", new ChromeDriverFactory());
        result.put("legacy_firefox", new LegacyFirefoxDriverFactory());
        result.put("firefox", new FirefoxDriverFactory());
        result.put("edge", new EdgeDriverFactory());
        result.put("internet explorer", new InternetExplorerDriverFactory());
        result.put("ie", new InternetExplorerDriverFactory());
        result.put("opera", new OperaDriverFactory());
        return result;
    }

    public WebDriver createWebDriver(Config config, Proxy proxy) {
        log.debug("browser={}", (Object)config.browser());
        log.debug("browser.version={}", (Object)config.browserVersion());
        log.debug("remote={}", (Object)config.remote());
        log.debug("browserSize={}", (Object)config.browserSize());
        log.debug("startMaximized={}", (Object)config.startMaximized());
        Browser browser = new Browser(config.browser(), config.headless());
        WebDriver webdriver = this.createWebDriverInstance(config, proxy, browser);
        this.browserResizer.adjustBrowserSize(config, webdriver);
        this.browserResizer.adjustBrowserPosition(config, webdriver);
        this.logBrowserVersion(webdriver);
        log.info("Selenide v. {}", (Object)SelenideDriver.class.getPackage().getImplementationVersion());
        this.logSeleniumInfo(config);
        return webdriver;
    }

    private WebDriver createWebDriverInstance(Config config, Proxy proxy, Browser browser) {
        DriverFactory webdriverFactory = this.findFactory(browser);
        if (config.remote() != null) {
            MutableCapabilities capabilities = webdriverFactory.createCapabilities(config, browser, proxy);
            return this.remoteDriverFactory.create(config, browser, capabilities);
        }
        if (config.driverManagerEnabled()) {
            webdriverFactory.setupWebdriverBinary();
        }
        return webdriverFactory.create(config, browser, proxy);
    }

    private DriverFactory findFactory(Browser browser) {
        return this.factories.computeIfAbsent(browser.name.toLowerCase(), browserName -> new DefaultDriverFactory());
    }

    protected void logSeleniumInfo(Config config) {
        if (config.remote() == null) {
            BuildInfo seleniumInfo = new BuildInfo();
            log.info("Selenium WebDriver v. {} build time: {}", (Object)seleniumInfo.getReleaseLabel(), (Object)seleniumInfo.getBuildTime());
        }
    }

    protected void logBrowserVersion(WebDriver webdriver) {
        if (webdriver instanceof HasCapabilities) {
            Capabilities capabilities = ((HasCapabilities)webdriver).getCapabilities();
            log.info("BrowserName={} Version={} Platform={}", new Object[]{capabilities.getBrowserName(), capabilities.getVersion(), capabilities.getPlatform()});
        } else {
            log.info("BrowserName={}", (Object)webdriver.getClass().getName());
        }
    }
}

