/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.impl.FileHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.openqa.selenium.Alert;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageSourceExtractor {
    private static final Logger log = LoggerFactory.getLogger(PageSourceExtractor.class);
    protected Set<String> printedErrors = new ConcurrentSkipListSet<String>();
    private final WebDriver driver;
    private final Config config;
    private final String fileName;

    public PageSourceExtractor(Config config, WebDriver driver, String fileName) {
        this.config = config;
        this.driver = driver;
        this.fileName = fileName;
    }

    protected File extract(boolean retryIfAlert) {
        File pageSource = new File(this.config.reportsFolder(), this.fileName + ".html");
        try {
            this.writeToFile(this.driver.getPageSource(), pageSource);
        }
        catch (UnhandledAlertException e) {
            if (retryIfAlert) {
                this.retryingExtractionOnAlert((Exception)((Object)e));
            } else {
                this.printOnce("savePageSourceToFile", e);
            }
        }
        catch (WebDriverException e) {
            log.warn("Failed to save page source to {}", (Object)this.fileName, (Object)e);
            this.writeToFile(e.toString(), pageSource);
            return pageSource;
        }
        catch (RuntimeException e) {
            log.error("Failed to save page source to {}", (Object)this.fileName, (Object)e);
            this.writeToFile(e.toString(), pageSource);
        }
        return pageSource;
    }

    protected void writeToFile(String content, File targetFile) {
        try (ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));){
            FileHelper.copyFile(in, targetFile);
        }
        catch (IOException e) {
            log.error("Failed to write file {}", (Object)targetFile.getAbsolutePath(), (Object)e);
        }
    }

    protected synchronized void printOnce(String action, Throwable error) {
        if (!this.printedErrors.contains(action)) {
            log.error(error.getMessage(), error);
            this.printedErrors.add(action);
        } else {
            log.error("Failed to {}: {}", (Object)action, (Object)error);
        }
    }

    private void retryingExtractionOnAlert(Exception e) {
        try {
            Alert alert = this.driver.switchTo().alert();
            log.error("{}: {}", (Object)e, (Object)alert.getText());
            alert.accept();
            this.extract(false);
        }
        catch (Exception unableToCloseAlert) {
            log.error("Failed to close alert", (Throwable)unableToCloseAlert);
        }
    }
}

